"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetRoute = exports.DeleteRoute = exports.ListRoutes = exports.CreateRoute = exports.ROUTE_TEMPLATE = void 0;
var ResourceFetch_1 = require("../../fetch/ResourceFetch");
var FetchConstants_1 = require("../../fetch/FetchConstants");
var api_1 = require("./api");
var common_1 = require("../common");
var ROUTE_TEMPLATE = function (args) { return ({
    apiVersion: api_1.OpenshiftApiVersions.ROUTE,
    kind: "Route",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        labels: __assign(__assign({}, (0, common_1.commonLabels)(__assign({}, args))), (0, common_1.runtimeLabels)()),
    },
    spec: {
        to: {
            name: args.resourceName,
            kind: "Service",
        },
        port: {
            targetPort: "8080-tcp",
        },
        tls: {
            termination: "edge",
            insecureEdgeTerminationPolicy: "None",
        },
    },
}); };
exports.ROUTE_TEMPLATE = ROUTE_TEMPLATE;
var CreateRoute = (function (_super) {
    __extends(CreateRoute, _super);
    function CreateRoute(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    CreateRoute.prototype.method = function () {
        return FetchConstants_1.HttpMethod.POST;
    };
    CreateRoute.prototype.body = function () {
        return JSON.stringify(this.args.resourceDataSource === common_1.ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : (0, exports.ROUTE_TEMPLATE)(__assign({}, this.args)));
    };
    CreateRoute.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.ROUTE, "/namespaces/").concat(this.args.namespace, "/routes");
    };
    return CreateRoute;
}(ResourceFetch_1.ResourceFetch));
exports.CreateRoute = CreateRoute;
var ListRoutes = (function (_super) {
    __extends(ListRoutes, _super);
    function ListRoutes() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ListRoutes.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    ListRoutes.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.ROUTE, "/namespaces/").concat(this.args.namespace, "/routes");
    };
    return ListRoutes;
}(ResourceFetch_1.ResourceFetch));
exports.ListRoutes = ListRoutes;
var DeleteRoute = (function (_super) {
    __extends(DeleteRoute, _super);
    function DeleteRoute(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    DeleteRoute.prototype.body = function () {
        return JSON.stringify({
            propagationPolicy: "Background",
        });
    };
    DeleteRoute.prototype.method = function () {
        return FetchConstants_1.HttpMethod.DELETE;
    };
    DeleteRoute.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.ROUTE, "/namespaces/").concat(this.args.namespace, "/routes/").concat(this.args.resourceName);
    };
    return DeleteRoute;
}(ResourceFetch_1.ResourceFetch));
exports.DeleteRoute = DeleteRoute;
var GetRoute = (function (_super) {
    __extends(GetRoute, _super);
    function GetRoute(args) {
        var _this = _super.call(this, args) || this;
        _this.args = args;
        return _this;
    }
    GetRoute.prototype.method = function () {
        return FetchConstants_1.HttpMethod.GET;
    };
    GetRoute.prototype.endpoint = function () {
        return "/apis/".concat(api_1.OpenshiftApiVersions.ROUTE, "/namespaces/").concat(this.args.namespace, "/routes/").concat(this.args.resourceName);
    };
    return GetRoute;
}(ResourceFetch_1.ResourceFetch));
exports.GetRoute = GetRoute;
//# sourceMappingURL=Route.js.map