import { CreateResourceFetchArgs, ResourceFetch, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { IObjectReference } from "kubernetes-models/v1";
import { ResourceDataSource, ResourceDescriptor, ResourceGroupDescriptor } from "../common";
export interface TLSConfig {
    insecureEdgeTerminationPolicy?: "None" | "Allow" | "Redirect";
    termination: "edge" | "passthrough" | "reencrypt";
}
export interface RouteSpec {
    host?: string;
    port: {
        targetPort: number | string;
    };
    tls: TLSConfig;
    to: IObjectReference;
}
export interface RouteDescriptor extends ResourceDescriptor {
    spec: RouteSpec;
}
export declare type RouteGroupDescriptor = ResourceGroupDescriptor<RouteDescriptor>;
export declare type CreateRouteTemplateArgs = {
    resourceDataSource: ResourceDataSource.TEMPLATE;
};
export declare type CreateRouteArgs = CreateResourceFetchArgs & (CreateRouteTemplateArgs | {
    descriptor: RouteDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const ROUTE_TEMPLATE: (args: CreateResourceFetchArgs & CreateRouteTemplateArgs) => RouteDescriptor;
export declare class CreateRoute extends ResourceFetch {
    protected args: CreateRouteArgs;
    constructor(args: CreateRouteArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class ListRoutes extends ResourceFetch {
    method(): HttpMethod;
    endpoint(): string;
}
export declare class DeleteRoute extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    body(): string;
    method(): HttpMethod;
    endpoint(): string;
}
export declare class GetRoute extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=Route.d.ts.map