import { DmnDocumentData } from "./DmnDocumentData";
import { DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
declare type NormalizedPosixPathRelativeToWorkspaceRoot = string & {};
export interface DmnLanguageServiceResource {
    content: string;
    normalizedPosixPathRelativeToTheWorkspaceRoot: NormalizedPosixPathRelativeToWorkspaceRoot;
}
declare type ImportIndexHierarchy = Map<NormalizedPosixPathRelativeToWorkspaceRoot, {
    deep: Set<NormalizedPosixPathRelativeToWorkspaceRoot>;
    immediate: Set<NormalizedPosixPathRelativeToWorkspaceRoot>;
}>;
declare type ImportIndexModels = Map<NormalizedPosixPathRelativeToWorkspaceRoot, {
    definitions: DMN15__tDefinitions;
    xml: string;
}>;
export interface ImportIndex {
    hierarchy: ImportIndexHierarchy;
    models: ImportIndexModels;
}
export declare class DmnLanguageService {
    private readonly args;
    private readonly parser;
    private readonly inputDataRegEx;
    private readonly decisionsTagRegExp;
    private readonly definitionsTagRegExp;
    constructor(args: {
        getModelXml: (args: {
            normalizedPosixPathRelativeToTheWorkspaceRoot: string;
        }) => Promise<string>;
    });
    private buildImportIndexModel;
    private recusivelyPopulateImportIndex;
    buildImportIndex(resources: DmnLanguageServiceResource[], depth?: number): Promise<ImportIndex>;
    getPathFromNodeId(resources: DmnLanguageServiceResource[], nodeId: string): string;
    getDmnDocumentData(xml: string): DmnDocumentData;
    getSpecVersion(xml: string): "1.0" | "1.1" | "1.2" | "1.3" | "1.4" | "1.5" | undefined;
}
export {};
//# sourceMappingURL=DmnLanguageService.d.ts.map