"use strict";
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validationPromise = void 0;
function validationPromise(yaml) {
    return new Promise(function (resolve, reject) {
        var worker = new Worker("/yard-validator-worker.js");
        worker.postMessage(yaml);
        worker.onmessage = function (e) {
            var e_1, _a, e_2, _b;
            var notifications = [];
            try {
                var validationResult = JSON.parse(e.data);
                try {
                    for (var _c = __values(validationResult.result), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var result = _d.value;
                        try {
                            for (var _e = (e_2 = void 0, __values(result.locations)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var location_1 = _f.value;
                                notifications.push({
                                    normalizedPosixPathRelativeToTheWorkspaceRoot: "",
                                    severity: "ERROR",
                                    message: result.issue,
                                    type: "PROBLEM",
                                    position: {
                                        startLineNumber: location_1.rowInFile,
                                        startColumn: 0,
                                        endLineNumber: 0,
                                        endColumn: 0,
                                    },
                                });
                            }
                        }
                        catch (e_2_1) { e_2 = { error: e_2_1 }; }
                        finally {
                            try {
                                if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                            }
                            finally { if (e_2) throw e_2.error; }
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
            }
            catch (e) {
            }
            resolve(notifications);
            worker.terminate();
        };
    });
}
exports.validationPromise = validationPromise;
//# sourceMappingURL=main.js.map