"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var api_1 = require("@kie-tools-core/editor/dist/api");
var api_2 = require("@kie-tools-core/workspace/dist/api");
var React = require("react");
var react_1 = require("react");
var MonacoEditor_1 = require("./monaco/MonacoEditor");
var MonacoEditorController_1 = require("./monaco/MonacoEditorController");
var RefForwardingTextEditor = function (props, forwardedRef) {
    var _a = __read((0, react_1.useState)(undefined), 2), initialContent = _a[0], setInitialContent = _a[1];
    var swfTextEditorRef = (0, react_1.useRef)(null);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        return {
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) {
                try {
                    setInitialContent({
                        originalContent: newContent,
                        normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: function () {
                var _a;
                return Promise.resolve(((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: function () {
                return Promise.resolve("");
            },
            undo: function () {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: function () {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: function () {
                return [];
            },
            setTheme: function (theme) {
                var _a;
                return ((_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
        };
    }, []);
    var setValidationErrors = function (errors) {
        if (!initialContent) {
            return;
        }
        var notifications = errors.map(function (error) { return ({
            type: "PROBLEM",
            normalizedPosixPathRelativeToTheWorkspaceRoot: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot,
            severity: "ERROR",
            message: "".concat(error.message),
            position: {
                startLineNumber: error.startLineNumber,
                startColumn: error.startColumn,
                endLineNumber: error.endLineNumber,
                endColumn: error.endColumn,
            },
        }); });
        props.setNotifications(initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    };
    var isVscode = (0, react_1.useCallback)(function () {
        return props.channelType === api_1.ChannelType.VSCODE_DESKTOP || props.channelType === api_1.ChannelType.VSCODE_WEB;
    }, [props.channelType]);
    var onContentChanged = (0, react_1.useCallback)(function (newContent, operation) {
        var _a, _b;
        switch (operation) {
            case MonacoEditorController_1.MonacoEditorOperation.EDIT:
                props.onNewEdit(new api_2.WorkspaceEdit(newContent));
                break;
            case MonacoEditorController_1.MonacoEditorOperation.UNDO:
                if (!isVscode()) {
                    (_a = swfTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
                }
                props.onStateControlCommandUpdate(api_1.StateControlCommand.UNDO);
                break;
            case MonacoEditorController_1.MonacoEditorOperation.REDO:
                if (!isVscode()) {
                    (_b = swfTextEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
                }
                props.onStateControlCommandUpdate(api_1.StateControlCommand.REDO);
                break;
        }
    }, [props, isVscode]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: isVscode() ||
            (initialContent && ((0, jsx_runtime_1.jsx)(MonacoEditor_1.MonacoEditor, { channelType: props.channelType, content: initialContent.originalContent, fileName: initialContent.normalizedPosixPathRelativeToTheWorkspaceRoot, onContentChange: onContentChanged, setValidationErrors: setValidationErrors, ref: swfTextEditorRef, isReadOnly: props.isReadOnly }))) }));
};
exports.TextEditor = React.forwardRef(RefForwardingTextEditor);
//# sourceMappingURL=TextEditor.js.map