"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeBackendProxy = void 0;
var vscode = require("vscode");
var api_1 = require("../api");
var SUGGEST_BACKEND_KEY = "SUGGEST_BACKEND";
var VsCodeBackendProxy = (function (_super) {
    __extends(VsCodeBackendProxy, _super);
    function VsCodeBackendProxy(context, backendI18n, backendExtensionId) {
        var _this = _super.call(this) || this;
        _this.context = context;
        _this.backendI18n = backendI18n;
        _this.backendExtensionId = backendExtensionId;
        return _this;
    }
    VsCodeBackendProxy.prototype.withCapability = function (serviceId, consumer) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.tryLoadBackendExtension(false)];
                    case 1:
                        _a.sent();
                        return [4, _super.prototype.withCapability.call(this, serviceId, consumer)];
                    case 2:
                        response = _a.sent();
                        if (response.status === api_1.CapabilityResponseStatus.MISSING_INFRA) {
                            this.suggestBackendExtension();
                        }
                        return [2, response];
                }
            });
        });
    };
    VsCodeBackendProxy.prototype.tryLoadBackendExtension = function (suggestInstall) {
        return __awaiter(this, void 0, void 0, function () {
            var backendExtension, backendExtensionApi, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!this.backendExtensionId) {
                            return [2];
                        }
                        backendExtension = vscode.extensions.getExtension(this.backendExtensionId);
                        if (!backendExtension) {
                            if (suggestInstall) {
                                this.trySuggestBackendExtension();
                            }
                            return [2];
                        }
                        if (this.backendManager && backendExtension) {
                            return [2];
                        }
                        if (!backendExtension.isActive) return [3, 1];
                        _a = backendExtension.exports;
                        return [3, 3];
                    case 1: return [4, backendExtension.activate()];
                    case 2:
                        _a = _b.sent();
                        _b.label = 3;
                    case 3:
                        backendExtensionApi = _a;
                        this.backendManager = backendExtensionApi.backendManager;
                        return [2];
                }
            });
        });
    };
    VsCodeBackendProxy.prototype.trySuggestBackendExtension = function () {
        var _this = this;
        var _a;
        var suggestBackend = (_a = this.context.globalState.get(SUGGEST_BACKEND_KEY)) !== null && _a !== void 0 ? _a : true;
        if (!suggestBackend) {
            return;
        }
        var i18n = this.backendI18n.getCurrent();
        vscode.window
            .showInformationMessage(i18n.installBackendExtensionMessage, i18n.installExtension, i18n.dontShowAgain)
            .then(function (selection) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!selection) {
                            return [2];
                        }
                        if (!(selection === i18n.installExtension)) return [3, 2];
                        return [4, vscode.env.openExternal(vscode.Uri.parse("".concat(vscode.env.uriScheme, ":extension/").concat(this.backendExtensionId)))];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        if (selection === i18n.dontShowAgain) {
                            this.context.globalState.update(SUGGEST_BACKEND_KEY, false);
                        }
                        return [2];
                }
            });
        }); });
    };
    VsCodeBackendProxy.prototype.suggestBackendExtension = function () {
        var _this = this;
        var i18n = this.backendI18n.getCurrent();
        vscode.window
            .showInformationMessage(i18n.installBackendExtensionMessage, i18n.installExtension)
            .then(function (selection) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!selection) {
                            return [2];
                        }
                        if (!(selection === i18n.installExtension)) return [3, 2];
                        return [4, vscode.env.openExternal(vscode.Uri.parse("".concat(vscode.env.uriScheme, ":extension/").concat(this.backendExtensionId)))];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        }); });
    };
    return VsCodeBackendProxy;
}(api_1.BackendProxy));
exports.VsCodeBackendProxy = VsCodeBackendProxy;
//# sourceMappingURL=VsCodeBackendProxy.js.map