import React from "react";
import { EmptyState, EmptyStateIcon, EmptyStateVariant, EmptyStateBody, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { PageSection } from "@patternfly/react-core/dist/js/components/Page";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const ServerUnavailablePage = ({ displayName, reload, ouiaId, ouiaSafe }) => {
    const name = displayName || process.env.KOGITO_APP_NAME;
    return (React.createElement(PageSection, Object.assign({ variant: "light" }, componentOuiaProps(ouiaId, "server-unavailable", ouiaSafe)),
        React.createElement(Bullseye, null,
            React.createElement(EmptyState, { variant: EmptyStateVariant.full },
                React.createElement(EmptyStateIcon, { icon: ExclamationCircleIcon, color: "var(--pf-global--danger-color--100)" }),
                React.createElement(Title, { headingLevel: "h1", size: "4xl" }, "Error connecting server"),
                React.createElement(EmptyStateBody, { "data-testid": "empty-state-body" }, `The ${name} could not access the server to display content.`),
                React.createElement(EmptyStateBody, { "data-testid": "empty-state-body" }, "Try reloading the page, or contact your administrator for more information."),
                React.createElement(Button, { variant: "primary", onClick: reload, "data-testid": "refresh-button" }, "Refresh")))));
};
//# sourceMappingURL=ServerUnavailablePage.js.map