import { FsCache, FsSchema } from "./FsCache";
import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
import { FsFlushManager } from "./FsFlushManager";
import { FsUsageCounter } from "./FsUsageCounter";
import { FsUnloadManager } from "./FsUnloadManager";
import { WorkspaceBroadcastEvents } from "../worker/api/WorkspaceBroadcastEvents";
import { WorkspaceFileBroadcastEvents } from "../worker/api/WorkspaceFileBroadcastEvents";
import { WORKSPACES_BROADCAST_CHANNEL, WORKSPACES_FILES_BROADCAST_CHANNEL, WorkspacesBroadcastEvents, WorkspacesFilesBroadcastEvents } from "../worker/api/WorkspacesBroadcastEvents";
export declare type BroadcasterWatchEvent = {
    channel: typeof WORKSPACES_BROADCAST_CHANNEL;
    onMessage: (message: WorkspacesBroadcastEvents) => void;
} | {
    channel: typeof WORKSPACES_FILES_BROADCAST_CHANNEL;
    onMessage: (message: WorkspacesFilesBroadcastEvents) => void;
} | {
    channel: string;
    onMessage: (message: WorkspaceBroadcastEvents | WorkspaceFileBroadcastEvents) => void;
};
export declare class Broadcastee {
    watch(args: BroadcasterWatchEvent): void;
    dispose(): void;
}
export declare type BroadcasterEvent = {
    channel: typeof WORKSPACES_BROADCAST_CHANNEL;
    message: () => Promise<WorkspacesBroadcastEvents>;
} | {
    channel: typeof WORKSPACES_FILES_BROADCAST_CHANNEL;
    message: () => Promise<WorkspacesFilesBroadcastEvents>;
} | {
    channel: string;
    message: () => Promise<WorkspaceBroadcastEvents | WorkspaceFileBroadcastEvents>;
};
export interface BroadcasterDispatch {
    broadcast(args: BroadcasterEvent): void;
}
export declare class Broadcaster implements BroadcasterDispatch {
    broadcast(args: BroadcasterEvent): Promise<void>;
}
export declare class FsService {
    private readonly args;
    private readonly fsFlushManager;
    private readonly readWriteFsUsageCounter;
    private readonly readonlyFsUsageCounter;
    private readonly fsCache;
    private readonly fsUnloadManager;
    constructor(args: {
        name: string;
    }, fsFlushManager: FsFlushManager, readWriteFsUsageCounter?: FsUsageCounter, readonlyFsUsageCounter?: FsUsageCounter, fsCache?: FsCache, fsUnloadManager?: FsUnloadManager);
    withReadonlyFsSchema<T>(fsMountPoint: string, callback: (args: {
        schema: FsSchema;
    }) => Promise<T>): Promise<T>;
    withReadWriteInMemoryFs<T>(fsMountPoint: string, callback: (args: {
        fs: KieSandboxWorkspacesFs;
        schema: FsSchema;
        broadcaster: BroadcasterDispatch;
    }) => Promise<T>): Promise<T>;
    withReadonlyInMemoryFs<T>(fsMountPoint: string, callback: (args: {
        fs: KieSandboxWorkspacesFs;
        schema: FsSchema;
    }) => Promise<T>): Promise<T>;
    private getReadonlyFs;
    private getFlushDebounceTimeoutInMs;
}
//# sourceMappingURL=FsService.d.ts.map