"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LfsWorkspaceService = void 0;
var minimatch_1 = require("minimatch");
var path_1 = require("path");
var EncoderDecoder_1 = require("../encoderdecoder/EncoderDecoder");
var WorkspacesContext_1 = require("../context/WorkspacesContext");
var LfsStorageService_1 = require("./LfsStorageService");
var LfsWorkspaceEvents_1 = require("./LfsWorkspaceEvents");
var broadcastChannel__postMessage = function (channel, message) {
    new BroadcastChannel(channel).postMessage(message);
};
var LfsWorkspaceService = (function () {
    function LfsWorkspaceService(args) {
        this.args = args;
        this.WORKSPACES_BROADCAST_CHANNEL_NAME = (0, LfsWorkspaceEvents_1.buildWorkspacesBroadcastChannelName)(this.args.eventNamePrefix);
    }
    LfsWorkspaceService.prototype.create = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var descriptor, files, e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.descriptorService.create(args.descriptorArgs)];
                    case 1:
                        descriptor = _a.sent();
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 6]);
                        return [4, args.storeFiles(descriptor)];
                    case 3:
                        files = _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage(this.WORKSPACES_BROADCAST_CHANNEL_NAME, {
                                type: "WSS_ADD_WORKSPACE",
                                workspaceId: descriptor.workspaceId,
                            });
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: descriptor.workspaceId,
                            }), { type: "WS_ADD", workspaceId: descriptor.workspaceId });
                        }
                        return [2, { descriptor: descriptor, files: files }];
                    case 4:
                        e_1 = _a.sent();
                        return [4, this.args.descriptorService.delete(descriptor.workspaceId)];
                    case 5:
                        _a.sent();
                        throw e_1;
                    case 6: return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.getFilesWithLazyContent = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var matcher, gitDirPath;
            var _this = this;
            return __generator(this, function (_a) {
                matcher = args.globPattern ? new minimatch_1.Minimatch(args.globPattern, { dot: true }) : undefined;
                gitDirPath = this.getAbsolutePath({ workspaceId: args.workspaceId, relativePath: ".git" });
                return [2, this.args.storageService.walk({
                        fs: args.fs,
                        startFromDirPath: this.getAbsolutePath({ workspaceId: args.workspaceId }),
                        shouldExcludeDir: function (dirPath) { return dirPath === gitDirPath; },
                        onVisit: function (_a) {
                            var absolutePath = _a.absolutePath, relativePath = _a.relativePath;
                            return __awaiter(_this, void 0, void 0, function () {
                                var workspaceFile;
                                var _this = this;
                                return __generator(this, function (_b) {
                                    workspaceFile = new WorkspacesContext_1.WorkspaceFile({
                                        workspaceId: args.workspaceId,
                                        relativePath: relativePath,
                                        getFileContents: function () {
                                            return _this.args.storageService.getFile(args.fs, absolutePath).then(function (f) { return f.getFileContents(); });
                                        },
                                    });
                                    if (matcher && !matcher.match(workspaceFile.name)) {
                                        return [2, undefined];
                                    }
                                    return [2, workspaceFile];
                                });
                            });
                        },
                    })];
            });
        });
    };
    LfsWorkspaceService.prototype.delete = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.descriptorService.delete(args.workspaceId)];
                    case 1:
                        _a.sent();
                        indexedDB.deleteDatabase("".concat(this.args.fsMountPoint).concat(args.workspaceId));
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage(this.WORKSPACES_BROADCAST_CHANNEL_NAME, {
                                type: "WSS_DELETE_WORKSPACE",
                                workspaceId: args.workspaceId,
                            });
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.workspaceId,
                            }), { type: "WS_DELETE", workspaceId: args.workspaceId });
                        }
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.rename = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.descriptorService.rename(args.workspaceId, args.newName)];
                    case 1:
                        _a.sent();
                        return [4, this.args.descriptorService.bumpLastUpdatedDate(args.workspaceId)];
                    case 2:
                        _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage(this.WORKSPACES_BROADCAST_CHANNEL_NAME, {
                                type: "WSS_RENAME_WORKSPACE",
                                workspaceId: args.workspaceId,
                            });
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.workspaceId,
                            }), { type: "WS_RENAME", workspaceId: args.workspaceId });
                        }
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.createOrOverwriteFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.storageService.createOrOverwriteFile(args.fs, this.toStorageFile(args.file))];
                    case 1:
                        _a.sent();
                        return [4, this.args.descriptorService.bumpLastUpdatedDate(args.file.workspaceId)];
                    case 2:
                        _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.file.workspaceId,
                            }), {
                                type: "WS_ADD_FILE",
                                relativePath: args.file.relativePath,
                            });
                        }
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.getFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var absolutePath, storageFile;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        absolutePath = this.getAbsolutePath(args);
                        return [4, this.args.storageService.getFile(args.fs, absolutePath)];
                    case 1:
                        storageFile = _a.sent();
                        if (!storageFile) {
                            return [2];
                        }
                        return [2, this.toWorkspaceFile(args.workspaceId, storageFile)];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.updateFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.storageService.updateFile(args.fs, this.toStorageFile(new WorkspacesContext_1.WorkspaceFile({
                            relativePath: args.file.relativePath,
                            workspaceId: args.file.workspaceId,
                            getFileContents: function () { return args.getNewContents().then(function (c) { return EncoderDecoder_1.encoder.encode(c); }); },
                        })))];
                    case 1:
                        _a.sent();
                        return [4, this.args.descriptorService.bumpLastUpdatedDate(args.file.workspaceId)];
                    case 2:
                        _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.file.workspaceId,
                            }), {
                                type: "WS_UPDATE_FILE",
                                relativePath: args.file.relativePath,
                            });
                        }
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.deleteFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.storageService.deleteFile(args.fs, this.toStorageFile(args.file).path)];
                    case 1:
                        _a.sent();
                        return [4, this.args.descriptorService.bumpLastUpdatedDate(args.file.workspaceId)];
                    case 2:
                        _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.file.workspaceId,
                            }), {
                                type: "WS_DELETE_FILE",
                                relativePath: args.file.relativePath,
                            });
                        }
                        return [2];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.renameFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var renamedStorageFile, renamedWorkspaceFile;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.args.storageService.renameFile(args.fs, this.toStorageFile(args.file), args.newFileNameWithoutExtension)];
                    case 1:
                        renamedStorageFile = _a.sent();
                        renamedWorkspaceFile = this.toWorkspaceFile(args.file.workspaceId, renamedStorageFile);
                        return [4, this.args.descriptorService.bumpLastUpdatedDate(args.file.workspaceId)];
                    case 2:
                        _a.sent();
                        if (args.broadcastArgs.broadcast) {
                            broadcastChannel__postMessage((0, LfsWorkspaceEvents_1.buildUniqueWorkspaceBroadcastChannelName)({
                                prefix: this.args.eventNamePrefix,
                                workspaceId: args.file.workspaceId,
                            }), {
                                type: "WS_RENAME_FILE",
                                oldRelativePath: args.file.relativePath,
                                newRelativePath: renamedWorkspaceFile.relativePath,
                            });
                        }
                        return [2, renamedWorkspaceFile];
                }
            });
        });
    };
    LfsWorkspaceService.prototype.existsFile = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.args.storageService.exists(args.fs, this.getAbsolutePath(args))];
            });
        });
    };
    LfsWorkspaceService.prototype.getAbsolutePath = function (args) {
        var _a;
        return (0, path_1.join)("/", (_a = args.relativePath) !== null && _a !== void 0 ? _a : "");
    };
    LfsWorkspaceService.prototype.toWorkspaceFile = function (workspaceId, storageFile) {
        return new WorkspacesContext_1.WorkspaceFile({
            workspaceId: workspaceId,
            getFileContents: storageFile.getFileContents,
            relativePath: (0, path_1.relative)(this.getAbsolutePath({ workspaceId: workspaceId }), storageFile.path),
        });
    };
    LfsWorkspaceService.prototype.toStorageFile = function (file) {
        return new LfsStorageService_1.LfsStorageFile({
            path: this.getAbsolutePath({ workspaceId: file.workspaceId, relativePath: file.relativePath }),
            getFileContents: file.getFileContents,
        });
    };
    return LfsWorkspaceService;
}());
exports.LfsWorkspaceService = LfsWorkspaceService;
//# sourceMappingURL=LfsWorkspaceService.js.map