"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildK8sApiServerEndpointsByResourceKind = void 0;
var common_1 = require("./common");
function buildK8sApiServerEndpointsByResourceKind(kubeApiServerUrl, token) {
    return __awaiter(this, void 0, void 0, function () {
        function ackApiResourceList(apiResourceList, apiGroupEndpoint, apiGroupVersion) {
            var e_1, _a;
            var _b, _c, _d;
            try {
                for (var _e = __values(apiResourceList.resources), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var apiResource = _f.value;
                    if (!new Set(apiResource.verbs).has("create")) {
                        continue;
                    }
                    var globalUrl = "".concat(apiGroupEndpoint, "/").concat(apiResource.name);
                    var globalPath = globalUrl.replace(kubeApiServerUrl, "");
                    var namespacedUrl = "".concat(apiGroupEndpoint, "/namespaces/:namespace/").concat(apiResource.name);
                    var namespacedPath = namespacedUrl.replace(kubeApiServerUrl, "");
                    if ((_b = map.get(apiResource.kind)) === null || _b === void 0 ? void 0 : _b.get(apiGroupVersion)) {
                        (0, common_1.consoleDebugMessage)("CONFLICT ON '".concat(apiResource.kind, "':"));
                        (0, common_1.consoleDebugMessage)((_c = map.get(apiResource.kind)) === null || _c === void 0 ? void 0 : _c.get(apiGroupVersion));
                        (0, common_1.consoleDebugMessage)("".concat(apiResource.namespaced) === "true"
                            ? {
                                url: { namespaced: namespacedUrl, global: globalUrl },
                                path: { namespaced: namespacedPath, global: globalPath },
                            }
                            : { url: { global: globalUrl }, path: { global: globalPath } });
                    }
                    map.set(apiResource.kind, new Map(__spreadArray(__spreadArray([], __read(__spreadArray([], __read(((_d = map.get(apiResource.kind)) !== null && _d !== void 0 ? _d : new Map()).entries()), false)), false), [
                        [
                            apiGroupVersion,
                            "".concat(apiResource.namespaced) === "true"
                                ? {
                                    url: { namespaced: namespacedUrl, global: globalUrl },
                                    path: { namespaced: namespacedPath, global: globalPath },
                                }
                                : { url: { global: globalUrl }, path: { global: globalPath } },
                        ],
                    ], false)));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        var fetchOpts, map, version, coreApiEndpoint, coreApi, apiGroups;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fetchOpts = token
                        ? { headers: { Authorization: "Bearer ".concat(token) } }
                        : {};
                    map = new Map();
                    (0, common_1.consoleDebugMessage)("Fetching Kubernetes version...");
                    return [4, fetch("".concat(kubeApiServerUrl, "/version"), fetchOpts)];
                case 1: return [4, (_a.sent()).json()];
                case 2:
                    version = _a.sent();
                    (0, common_1.consoleDebugMessage)(version);
                    (0, common_1.consoleDebugMessage)("");
                    coreApiEndpoint = "".concat(kubeApiServerUrl, "/api/v1");
                    (0, common_1.consoleDebugMessage)("Fetching Resources of '".concat(coreApiEndpoint, "'"));
                    return [4, fetch("".concat(coreApiEndpoint), fetchOpts)];
                case 3: return [4, (_a.sent()).json()];
                case 4:
                    coreApi = _a.sent();
                    ackApiResourceList(coreApi, "".concat(coreApiEndpoint), "v1");
                    return [4, fetch("".concat(kubeApiServerUrl, "/apis"), fetchOpts)];
                case 5: return [4, (_a.sent()).json()];
                case 6:
                    apiGroups = _a.sent();
                    return [4, Promise.all(apiGroups.groups
                            .flatMap(function (group) { return group.versions; })
                            .map(function (version) { return __awaiter(_this, void 0, void 0, function () {
                            var endpoint, apiResourceList;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        endpoint = "".concat(kubeApiServerUrl, "/apis/").concat(version.groupVersion);
                                        (0, common_1.consoleDebugMessage)("Fetching Resources of '".concat(endpoint, "'"));
                                        return [4, fetch("".concat(endpoint), fetchOpts)];
                                    case 1: return [4, (_a.sent()).json()];
                                    case 2:
                                        apiResourceList = _a.sent();
                                        ackApiResourceList(apiResourceList, "".concat(endpoint), version.groupVersion);
                                        return [2];
                                }
                            });
                        }); }))];
                case 7:
                    _a.sent();
                    return [2, map];
            }
        });
    });
}
exports.buildK8sApiServerEndpointsByResourceKind = buildK8sApiServerEndpointsByResourceKind;
//# sourceMappingURL=k8sApiServerEndpointsByResourceKind.js.map