"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DelegatingModelReducer = void 0;
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var get = Reflect.get;
var reduce = function (model, action, reducers) {
    var _a;
    var modelType = (0, PMMLModelHelper_1.getModelType)(model);
    var reducer = reducers.get(modelType);
    return (_a = reducer === null || reducer === void 0 ? void 0 : reducer.factory(reducer.reducer(model, action))) !== null && _a !== void 0 ? _a : model;
};
var DelegatingModelReducer = function (historyService, reducers) {
    return function (state, action) {
        if (state === undefined || action === undefined || action.payload === undefined) {
            return state;
        }
        var changed = false;
        var newState = [];
        state.forEach(function (m) { return newState.push(m); });
        var modelIndex = get(action.payload, "modelIndex");
        if (modelIndex === undefined) {
            state.forEach(function (model, index) {
                var modelAction = Object.assign({}, action, { payload: __assign(__assign({}, action.payload), { modelIndex: index }) });
                var newModel = reduce(model, modelAction, reducers);
                if (model !== newModel) {
                    changed = true;
                    newState[index] = newModel;
                }
            });
        }
        if (modelIndex >= 0 && modelIndex < state.length) {
            var model = state[modelIndex];
            var newModel = reduce(model, action, reducers);
            if (model !== newModel) {
                changed = true;
                newState[modelIndex] = newModel;
            }
        }
        if (changed) {
            return newState;
        }
        return state;
    };
};
exports.DelegatingModelReducer = DelegatingModelReducer;
//# sourceMappingURL=DelegatingModelReducer.js.map