"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputsHandler = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Modal_1 = require("@patternfly/react-core/dist/js/components/Modal");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var close_icon_1 = require("@patternfly/react-icons/dist/js/icons/close-icon");
var warning_triangle_icon_1 = require("@patternfly/react-icons/dist/js/icons/warning-triangle-icon");
var OutputsContainer_1 = require("./OutputsContainer");
var EditorScorecard_1 = require("../../EditorScorecard");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var atoms_1 = require("../../EditorCore/atoms");
var OutputsHandler = function (props) {
    var modelIndex = props.modelIndex, output = props.output, miningSchema = props.miningSchema, validateOutputFieldName = props.validateOutputFieldName, deleteOutputField = props.deleteOutputField, commitOutputField = props.commitOutputField;
    var _a = __read((0, react_1.useState)(false), 2), isModalOpen = _a[0], setIsModalOpen = _a[1];
    var setActiveOperation = (0, EditorScorecard_1.useOperation)().setActiveOperation;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().build()); }, [modelIndex, output, miningSchema]);
    var toggleModal = function () {
        setActiveOperation(EditorScorecard_1.Operation.NONE);
        setIsModalOpen(!isModalOpen);
    };
    var header = ((0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h1", size: Title_1.TitleSizes["2xl"] }, { children: "Outputs" })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ type: "button", variant: Button_1.ButtonVariant.plain, onClick: toggleModal, "data-title": "OutputsModalClose" }, { children: (0, jsx_runtime_1.jsx)(close_icon_1.CloseIcon, {}) })) })] })));
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length === 0 && ((0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: toggleModal, "data-title": "Outputs" }, { children: "Set Outputs" }))), validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorTooltip, __assign({ validations: validations }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", icon: (0, jsx_runtime_1.jsx)(warning_triangle_icon_1.WarningTriangleIcon, { size: "sm", color: "orange" }), onClick: toggleModal, "data-title": "Outputs" }, { children: "Set Outputs" })) }))), (0, jsx_runtime_1.jsx)(Modal_1.Modal, __assign({ "aria-label": "outputs", title: "Outputs", header: header, isOpen: isModalOpen, showClose: false, variant: Modal_1.ModalVariant.large, onEscapePress: function () { return false; }, "data-title": "OutputsModal" }, { children: (0, jsx_runtime_1.jsx)(OutputsContainer_1.OutputsContainer, { modelIndex: modelIndex, output: output, miningSchema: miningSchema, validateOutputFieldName: validateOutputFieldName, deleteOutputField: deleteOutputField, commitOutputField: commitOutputField }) }))] }));
};
exports.OutputsHandler = OutputsHandler;
//# sourceMappingURL=OutputsHandler.js.map