"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputFieldExtendedProperties = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var FormSelect_1 = require("@patternfly/react-core/dist/js/components/FormSelect");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var atoms_1 = require("../../EditorScorecard/atoms");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var OutputFieldExtendedProperties = function (props) {
    var activeOutputField = props.activeOutputField, activeOutputFieldIndex = props.activeOutputFieldIndex, modelIndex = props.modelIndex, targetFields = props.targetFields, commit = props.commit;
    var _a = __read((0, react_1.useState)(), 2), optype = _a[0], setOptype = _a[1];
    var _b = __read((0, react_1.useState)(), 2), targetField = _b[0], setTargetField = _b[1];
    var _c = __read((0, react_1.useState)(), 2), feature = _c[0], setFeature = _c[1];
    var _d = __read((0, react_1.useState)(), 2), value = _d[0], setValue = _d[1];
    var _e = __read((0, react_1.useState)(), 2), rank = _e[0], setRank = _e[1];
    var _f = __read((0, react_1.useState)(), 2), rankOrder = _f[0], setRankOrder = _f[1];
    var _g = __read((0, react_1.useState)(), 2), segmentId = _g[0], setSegmentId = _g[1];
    var _h = __read((0, react_1.useState)(), 2), isFinalResult = _h[0], setIsFinalResult = _h[1];
    (0, react_1.useEffect)(function () {
        if (activeOutputField === undefined) {
            return;
        }
        setOptype(activeOutputField.optype);
        setTargetField(activeOutputField.targetField);
        setFeature(activeOutputField.feature);
        setValue(activeOutputField.value);
        setRank(activeOutputField.rank);
        setRankOrder(activeOutputField.rankOrder);
        setSegmentId(activeOutputField.segmentId);
        setIsFinalResult(activeOutputField.isFinalResult);
    }, [props]);
    var targetFieldsOptions = (0, react_1.useMemo)(function () {
        var options = __spreadArray([], __read(targetFields), false);
        if (options.length) {
            options.sort().unshift("");
        }
        return options;
    }, [targetFields]);
    var toNumber = function (_value) {
        if (_value === "") {
            return undefined;
        }
        var n = Number(_value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    var optypeEditor = GenericSelectorEditor("output-optype", ["", "categorical", "continuous", "ordinal"], (optype !== null && optype !== void 0 ? optype : "").toString(), function (_selection) {
        setOptype(_selection === "" ? undefined : _selection);
        commit({
            optype: _selection === "" ? undefined : _selection,
        });
    });
    var featureEditor = GenericSelectorEditor("output-feature", [
        { value: "" },
        { value: "decision", isDisabled: true },
        { value: "predictedValue" },
        { value: "reasonCode" },
        { value: "transformedValue", isDisabled: true },
        { value: "warning" },
    ], (feature !== null && feature !== void 0 ? feature : "").toString(), function (_selection) {
        setFeature(_selection === "" ? undefined : _selection);
        commit({
            feature: _selection === "" ? undefined : _selection,
        });
    });
    var rankOrderEditor = GenericSelectorEditor("output-rankOrder", ["", "ascending", "descending"], (rankOrder !== null && rankOrder !== void 0 ? rankOrder : "").toString(), function (_selection) {
        setRankOrder(_selection === "" ? undefined : _selection);
        commit({
            rankOrder: _selection === "" ? undefined : _selection,
        });
    }, value !== undefined && value.length > 0);
    var isFinalResultEditor = GenericSelectorEditor("output-isFinalResult", ["", "true", "false"], (isFinalResult !== null && isFinalResult !== void 0 ? isFinalResult : "").toString(), function (_selection) {
        setIsFinalResult(_selection === "" ? undefined : Boolean(_selection));
        commit({
            isFinalResult: _selection === "" ? undefined : Boolean(_selection),
        });
    });
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validationsTargetField = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(activeOutputFieldIndex).forTargetField().build());
    }, [modelIndex, activeOutputFieldIndex, activeOutputField]);
    return ((0, jsx_runtime_1.jsxs)(Form_1.Form, { children: [(0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "optype", fieldId: "output-optype-helper", helperText: "Indicates the admissible operations on the values.", className: "outputs-container__extended-properties__field" }, { children: optypeEditor })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Target field", fieldId: "output-targetField-helper", helperText: validationsTargetField.length === 0 ? "" : validationsTargetField[0].message, className: "outputs-container__extended-properties__field", validated: validationsTargetField.length === 0 ? "default" : "warning", labelIcon: !targetFieldsOptions.length ? ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "There are no Mining Schema fields with target usage type." }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info for Target Field", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) }))) : ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {})) }, { children: (0, jsx_runtime_1.jsx)(FormSelect_1.FormSelect, __assign({ id: "output-targetField", value: (targetField !== null && targetField !== void 0 ? targetField : "").toString(), onChange: function (selection) {
                        if (selection !== targetField) {
                            setTargetField(selection === "" ? undefined : selection);
                            commit({ targetField: selection === "" ? undefined : selection });
                        }
                    }, isDisabled: !targetFieldsOptions.length, validated: validationsTargetField.length === 0 ? "default" : "warning" }, { children: targetFieldsOptions.map(function (option, index) { return ((0, jsx_runtime_1.jsx)(FormSelect_1.FormSelectOption, { value: option, label: option }, index)); }) })) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Feature", fieldId: "output-feature-helper", helperText: "Specifies the value the output field takes from the computed mining result.", className: "outputs-container__extended-properties__field", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Decision and Transformed value are not supported by scorecards" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info about Feature", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: featureEditor })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Value", fieldId: "output-value-helper", helperText: "Used in conjunction with result features referring to specific values.", className: "outputs-container__extended-properties__field", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Value property cannot be used together with Rank property" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info about Feature", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "output-value", name: "output-value", "aria-describedby": "output-value-helper", autoComplete: "off", value: (value !== null && value !== void 0 ? value : "").toString(), onChange: function (e) { return setValue(e); }, onBlur: function () {
                        return commit({
                            value: value === "" ? undefined : value,
                        });
                    }, isDisabled: rank !== undefined }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Rank", fieldId: "output-rank-helper", helperText: "Specifies the rank of the feature value from the mining result that should be selected.", className: "outputs-container__extended-properties__field", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "Rank property cannot be used together with Value property" }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info about Feature", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "output-rank", name: "output-rank", "aria-describedby": "output-rank-helper", autoComplete: "off", value: rank !== null && rank !== void 0 ? rank : "", onChange: function (e) { return setRank(toNumber(e)); }, onBlur: function () {
                        return commit({
                            rank: rank,
                        });
                    }, isDisabled: value !== undefined && value.length > 0 }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Rank order", fieldId: "output-rankOrder-helper", helperText: "Determines the sorting order when ranking the results.", className: "outputs-container__extended-properties__field" }, { children: rankOrderEditor })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Segment Id", fieldId: "output-segmentId-helper", helperText: "Provides an approach to deliver results from Segments.", className: "outputs-container__extended-properties__field" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "output-segmentId", name: "output-segmentId", "aria-describedby": "output-segmentId-helper", autoComplete: "off", value: segmentId !== null && segmentId !== void 0 ? segmentId : "", onChange: function (e) { return setSegmentId(e); }, onBlur: function () {
                        return commit({
                            segmentId: segmentId,
                        });
                    } }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Final result?", fieldId: "output-isFinalResult-helper", helperText: "Should the field be returned to the user or is only used as input.", className: "outputs-container__extended-properties__field" }, { children: isFinalResultEditor }))] }));
};
exports.OutputFieldExtendedProperties = OutputFieldExtendedProperties;
var GenericSelectorEditor = function (id, items, selection, onSelect, isDisabled) {
    return (0, jsx_runtime_1.jsx)(atoms_1.GenericSelector, { id: id, items: items, selection: selection, onSelect: onSelect, isDisabled: isDisabled });
};
//# sourceMappingURL=OutputFieldExtendedProperties.js.map