"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Select_1 = require("@patternfly/react-core/dist/js/components/Select");
require("./OutputFieldRow.scss");
var atoms_1 = require("../atoms");
var exclamation_circle_icon_1 = require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var EditorScorecard_1 = require("../../EditorScorecard");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var dataTypes = [
    "string",
    "integer",
    "float",
    "double",
    "boolean",
    "date",
    "time",
    "dateTime",
    "dateDaysSince[0]",
    "dateDaysSince[1960]",
    "dateDaysSince[1970]",
    "dateDaysSince[1980]",
    "timeSeconds",
    "dateTimeSecondsSince[0]",
    "dateTimeSecondsSince[1960]",
    "dateTimeSecondsSince[1970]",
    "dateTimeSecondsSince[1980]",
];
var OutputFieldEditRow = function (props) {
    var _a, _b, _c;
    var modelIndex = props.modelIndex, outputField = props.outputField, outputFieldIndex = props.outputFieldIndex, validateOutputName = props.validateOutputName, viewExtendedProperties = props.viewExtendedProperties, onCommitAndClose = props.onCommitAndClose, onCommit = props.onCommit, onCancel = props.onCancel;
    var activeOperation = (0, EditorScorecard_1.useOperation)().activeOperation;
    var _d = __read((0, react_1.useState)({ value: "", valid: false }), 2), name = _d[0], setName = _d[1];
    var _e = __read((0, react_1.useState)("boolean"), 2), dataType = _e[0], setDataType = _e[1];
    var _f = __read((0, react_1.useState)(), 2), optype = _f[0], setOptype = _f[1];
    var _g = __read((0, react_1.useState)(), 2), targetField = _g[0], setTargetField = _g[1];
    var _h = __read((0, react_1.useState)(), 2), feature = _h[0], setFeature = _h[1];
    var _j = __read((0, react_1.useState)(), 2), value = _j[0], setValue = _j[1];
    var _k = __read((0, react_1.useState)(), 2), rank = _k[0], setRank = _k[1];
    var _l = __read((0, react_1.useState)(), 2), rankOrder = _l[0], setRankOrder = _l[1];
    var _m = __read((0, react_1.useState)(), 2), segmentId = _m[0], setSegmentId = _m[1];
    var _o = __read((0, react_1.useState)(), 2), isFinalResult = _o[0], setIsFinalResult = _o[1];
    (0, react_1.useEffect)(function () {
        if (outputField === undefined) {
            return;
        }
        setName({
            value: outputField.name,
            valid: validateOutputName(outputField.name),
        });
        setDataType(outputField.dataType);
        setOptype(outputField.optype);
        setTargetField(outputField.targetField);
        setFeature(outputField.feature);
        setValue(outputField.value);
        setRank(outputField.rank);
        setRankOrder(outputField.rankOrder);
        setSegmentId(outputField.segmentId);
        setIsFinalResult(outputField.isFinalResult);
    }, [props]);
    var _p = __read((0, react_1.useState)(false), 2), isTypeSelectOpen = _p[0], setIsTypeSelectOpen = _p[1];
    var typeToggle = function (isOpen) {
        setIsTypeSelectOpen(isOpen);
    };
    var ref = (0, react_cool_onclickoutside_1.default)(function () {
        if (name === null || name === void 0 ? void 0 : name.valid) {
            onCommitAndClose();
        }
        else {
            onCancel();
        }
    }, {
        disabled: activeOperation !== EditorScorecard_1.Operation.UPDATE_OUTPUT,
        eventTypes: ["click"],
    });
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var targetFieldValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build());
    }, [outputFieldIndex, modelIndex, outputField]);
    return ((0, jsx_runtime_1.jsx)("section", __assign({ className: "editable-item__inner", ref: ref, tabIndex: 0, onKeyDown: function (e) {
            if (e.key === "Escape") {
                onCancel();
            }
        } }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Name", fieldId: "output-name-helper", isRequired: true, helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: (0, jsx_runtime_1.jsx)(exclamation_circle_icon_1.ExclamationCircleIcon, {}), validated: (name === null || name === void 0 ? void 0 : name.valid) ? "default" : "error" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "output-name", name: "output-name", "aria-describedby": "output-name-helper", value: (_b = (_a = name === null || name === void 0 ? void 0 : name.value) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : "", placeholder: "Name", validated: (name === null || name === void 0 ? void 0 : name.valid) ? "default" : "error", autoFocus: true, onChange: function (e) {
                                            setName({
                                                value: e,
                                                valid: validateOutputName(e),
                                            });
                                        }, onBlur: function (e) {
                                            if (name === null || name === void 0 ? void 0 : name.valid) {
                                                onCommit({
                                                    name: name.value,
                                                });
                                            }
                                            else {
                                                setName({
                                                    value: outputField === null || outputField === void 0 ? void 0 : outputField.name,
                                                    valid: validateOutputName(outputField.name),
                                                });
                                            }
                                        }, ouiaId: "set-output-field-name" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Data type", fieldId: "output-dataType-helper", style: { width: "12em" }, isRequired: true, "data-ouia-component-id": "select-output-field-type" }, { children: (0, jsx_runtime_1.jsx)(Select_1.Select, __assign({ id: "output-dataType", name: "output-dataType", "aria-label": "Select Input", "aria-describedby": "output-dataType-helper", className: "ignore-onclickoutside", variant: Select_1.SelectVariant.single, onToggle: typeToggle, onSelect: function (event, selection, isPlaceholder) {
                                            setIsTypeSelectOpen(false);
                                            setDataType(isPlaceholder ? undefined : selection);
                                            onCommit({
                                                dataType: isPlaceholder ? undefined : selection,
                                            });
                                        }, selections: dataType, isOpen: isTypeSelectOpen, placeholder: "Type", menuAppendTo: "parent" }, { children: dataTypes.map(function (dt, _index) { return ((0, jsx_runtime_1.jsx)(Select_1.SelectOption, { value: dt, "data-ouia-component-type": "select-option" }, _index)); }) })) })) }))] })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Split_1.Split, { children: (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Properties", fieldId: "output-labels-helper" }, { children: (0, jsx_runtime_1.jsx)(atoms_1.OutputLabelsEditMode, { optype: optype, setOptype: setOptype, targetField: targetField, setTargetField: setTargetField, targetFieldValidation: targetFieldValidation, feature: feature, setFeature: setFeature, value: value, setValue: setValue, rank: rank, setRank: setRank, rankOrder: rankOrder, setRankOrder: setRankOrder, segmentId: segmentId, setSegmentId: setSegmentId, isFinalResult: isFinalResult, setIsFinalResult: setIsFinalResult, viewExtendedProperties: viewExtendedProperties, commit: onCommit, isDisabled: (_c = !(name === null || name === void 0 ? void 0 : name.valid)) !== null && _c !== void 0 ? _c : true }) })) }) }) })] })) })));
};
exports.default = OutputFieldEditRow;
//# sourceMappingURL=OutputFieldEditRow.js.map