"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MiningSchemaContext = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = require("react");
var react_1 = require("react");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Bullseye_1 = require("@patternfly/react-core/dist/js/layouts/Bullseye");
var Alert_1 = require("@patternfly/react-core/dist/js/components/Alert");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var react_transition_group_1 = require("react-transition-group");
var lodash_1 = require("lodash");
var EmptyMiningSchema_1 = require("../EmptyMiningSchema/EmptyMiningSchema");
var MiningSchemaFields_1 = require("../MiningSchemaFields/MiningSchemaFields");
var MiningSchemaAddFields_1 = require("../MiningSchemaAddFields/MiningSchemaAddFields");
var MiningSchemaPropertiesEdit_1 = require("../MiningSchemaPropertiesEdit/MiningSchemaPropertiesEdit");
require("./MiningSchemaContainer.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var NoMiningSchemaFieldsOptions_1 = require("../NoMiningSchemaFieldsOptions/NoMiningSchemaFieldsOptions");
var MiningSchemaContainer = function (props) {
    var modelIndex = props.modelIndex, dataDictionary = props.dataDictionary, miningSchema = props.miningSchema, onAddField = props.onAddField, onDeleteField = props.onDeleteField, onUpdateField = props.onUpdateField;
    var _a = __read((0, react_1.useState)(prepareFieldOptions(dataDictionary, miningSchema)), 2), fields = _a[0], setFields = _a[1];
    var _b = __read((0, react_1.useState)("overview"), 2), viewSection = _b[0], setViewSection = _b[1];
    var _c = __read((0, react_1.useState)(-1), 2), editingField = _c[0], setEditingField = _c[1];
    var _d = __read((0, react_1.useState)(undefined), 2), miningFieldFocusIndex = _d[0], setMiningFieldFocusIndex = _d[1];
    var handleAddFields = function (fieldsToAdd) {
        if (fieldsToAdd.length) {
            onAddField(fieldsToAdd);
        }
    };
    var handleDeleteField = function (index, interaction) {
        var _a;
        onDeleteField(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setMiningFieldFocusIndex(index);
        }
        setEditingField(-1);
    };
    var handleEditField = function (index) {
        setEditingField(index);
    };
    var handleCancelEditing = function () {
        setEditingField(-1);
    };
    var goToProperties = function () {
        setViewSection("properties");
    };
    var handlePropertiesSave = function (field) {
        if (!(0, lodash_1.isEqual)(field, (0, lodash_1.pickBy)(miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField], function (value) { return value !== undefined; }))) {
            onUpdateField(editingField, miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField].name, field);
        }
    };
    var handlePropertiesClose = function () {
        setViewSection("overview");
    };
    var handlePropertyDelete = function (index, updatedField) {
        onUpdateField(index, miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField[editingField].name, updatedField);
    };
    var getTransition = function (currentState) {
        if (currentState === "overview") {
            return "mining-schema__overview";
        }
        else if (currentState === "properties") {
            return "mining-schema__properties";
        }
    };
    (0, react_1.useEffect)(function () {
        setFields(prepareFieldOptions(dataDictionary, miningSchema));
    }, [dataDictionary, miningSchema]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().build()); }, [dataDictionary, miningSchema]);
    (0, react_1.useEffect)(function () {
        var _a;
        if (miningFieldFocusIndex !== undefined) {
            (_a = document.querySelector("#mining-schema-field-n".concat(miningFieldFocusIndex))) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [miningSchema, miningFieldFocusIndex]);
    var isDisabled = (0, react_1.useMemo)(function () {
        return fields.length === 0 || editingField !== -1;
    }, [fields, editingField]);
    return ((0, jsx_runtime_1.jsx)("section", __assign({ className: "mining-schema", "data-testid": "mining-schema-container", "data-ouia-component-id": "mining-container", "data-ouia-component-type": "editor-container" }, { children: (0, jsx_runtime_1.jsx)(exports.MiningSchemaContext.Provider, __assign({ value: editingField }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.SwitchTransition, __assign({ mode: "out-in" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.CSSTransition, __assign({ timeout: {
                        enter: 230,
                        exit: 100,
                    }, classNames: getTransition(viewSection) }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [viewSection === "overview" && ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true, className: "mining-schema__overview" }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h4", size: Title_1.TitleSizes.xl }, { children: "Add Fields" })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(MiningSchemaAddFields_1.default, { options: fields, onAdd: handleAddFields, isDisabled: isDisabled }) }), validations.length > 0 && ((0, jsx_runtime_1.jsx)("section", __assign({ className: "mining-schema__validation-alert", "data-ouia-component-id": "validation-container", "data-ouia-component-type": "validation-alerts" }, { children: (0, jsx_runtime_1.jsx)(Alert_1.Alert, { variant: "warning", isInline: true, title: "Some items are invalid and need attention." }) }))), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "mining-schema__fields" }, { children: (0, jsx_runtime_1.jsxs)("section", { children: [(miningSchema === undefined || (miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.length) === 0) && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [fields.length === 0 && ((0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, __assign({ style: { height: "40vh" } }, { children: (0, jsx_runtime_1.jsx)(NoMiningSchemaFieldsOptions_1.default, {}) }))), " ", fields.length > 0 && ((0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, __assign({ style: { height: "40vh" } }, { children: (0, jsx_runtime_1.jsx)(EmptyMiningSchema_1.default, {}) })))] })), miningSchema && miningSchema.MiningField.length > 0 && ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (0, jsx_runtime_1.jsx)(MiningSchemaFields_1.default, { modelIndex: modelIndex, dataDictionary: dataDictionary, fields: miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField, onAddProperties: goToProperties, onDelete: handleDeleteField, onPropertyDelete: handlePropertyDelete, onEdit: handleEditField, onCancel: handleCancelEditing }) }))] }) }))] }))), viewSection === "properties" && ((0, jsx_runtime_1.jsx)(MiningSchemaPropertiesEdit_1.default, { modelIndex: modelIndex, miningFieldIndex: editingField, field: miningSchema.MiningField[editingField], onSave: handlePropertiesSave, onClose: handlePropertiesClose }))] }) }), viewSection) })) })) })));
};
exports.default = MiningSchemaContainer;
exports.MiningSchemaContext = React.createContext(-1);
var prepareFieldOptions = function (dictionary, miningSchema) {
    if (dictionary) {
        return dictionary.DataField.filter(function (field) { return field.name !== undefined; }).map(function (field) { return ({
            name: field.name,
            isSelected: miningSchema
                ? (miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.findIndex(function (miningField) { return miningField.name === field.name; })) > -1
                : false,
        }); });
    }
    else {
        return [];
    }
};
//# sourceMappingURL=MiningSchemaContainer.js.map