"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScorecardEditorPage = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var molecules_1 = require("../../EditorCore/molecules");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var organisms_1 = require("../organisms");
var __1 = require("../../..");
var reducers_1 = require("../../../reducers");
var react_redux_1 = require("react-redux");
require("./ScorecardEditorPage.scss");
var organisms_2 = require("../../EditorCore/organisms");
var history_1 = require("../../../history");
var ScorecardEditorPage = function (props) {
    var _a, _b, _c, _d, _e, _f;
    var modelIndex = props.modelIndex;
    var _g = (0, history_1.useHistoryService)(), service = _g.service, getCurrentState = _g.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var model = (0, react_redux_1.useSelector)(function (state) {
        var _model = state.models ? state.models[props.modelIndex] : undefined;
        if (_model && _model instanceof pmml_editor_marshaller_1.Scorecard) {
            return _model;
        }
        return undefined;
    });
    var modelName = (0, react_1.useMemo)(function () { return (0, __1.getModelName)(model); }, [model]);
    var characteristics = (0, react_1.useMemo)(function () { return model === null || model === void 0 ? void 0 : model.Characteristics; }, [model]);
    var miningSchema = (0, react_1.useMemo)(function () { return model === null || model === void 0 ? void 0 : model.MiningSchema; }, [model]);
    var output = (0, react_1.useMemo)(function () { return model === null || model === void 0 ? void 0 : model.Output; }, [model]);
    var validateOutputName = (0, react_1.useCallback)(function (index, name) {
        var _a;
        if (name.toString().trim().length === 0) {
            return false;
        }
        var existing = (_a = output === null || output === void 0 ? void 0 : output.OutputField) !== null && _a !== void 0 ? _a : [];
        var matching = existing.filter(function (c, _index) { return _index !== index && c.name === name; });
        return matching.length === 0;
    }, [output]);
    var isBaselineScoreDisabled = (0, react_1.useMemo)(function () {
        return ((characteristics === null || characteristics === void 0 ? void 0 : characteristics.Characteristic) !== undefined &&
            characteristics.Characteristic.length > 0 &&
            characteristics.Characteristic.every(function (characteristic) { return characteristic.baselineScore !== undefined; }));
    }, [characteristics]);
    var onDeleteOutputField = (0, react_1.useCallback)(function (_index) {
        dispatch({
            type: reducers_1.Actions.DeleteOutput,
            payload: {
                modelIndex: modelIndex,
                outputIndex: _index,
            },
        });
    }, [modelIndex, output]);
    var onUpdateOutputField = (0, react_1.useCallback)(function (_index, _outputField) {
        if (_index === undefined) {
            dispatch({
                type: reducers_1.Actions.AddOutput,
                payload: {
                    modelIndex: modelIndex,
                    outputField: _outputField,
                },
            });
        }
        else {
            dispatch({
                type: reducers_1.Actions.UpdateOutput,
                payload: {
                    modelIndex: modelIndex,
                    outputIndex: _index,
                    outputField: _outputField,
                },
            });
        }
    }, [modelIndex]);
    var onUpdateModelName = (0, react_1.useCallback)(function (_modelName) {
        if (_modelName !== modelName) {
            dispatch({
                type: reducers_1.Actions.Scorecard_SetModelName,
                payload: {
                    modelIndex: modelIndex,
                    modelName: _modelName === "" ? undefined : _modelName,
                },
            });
        }
    }, [modelIndex]);
    var onUpdateCoreProperty = (0, react_1.useCallback)(function (_props) {
        dispatch({
            type: reducers_1.Actions.Scorecard_SetCoreProperties,
            payload: {
                modelIndex: modelIndex,
                isScorable: _props.isScorable,
                functionName: _props.functionName,
                algorithmName: _props.algorithmName,
                baselineScore: _props.baselineScore,
                baselineMethod: _props.baselineMethod,
                initialScore: _props.initialScore,
                useReasonCodes: _props.areReasonCodesUsed,
                reasonCodeAlgorithm: _props.reasonCodeAlgorithm,
            },
        });
    }, [modelIndex]);
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ "data-testid": "editor-page", className: "editor" }, { children: [!model && (0, jsx_runtime_1.jsx)(organisms_2.EmptyStateModelNotFound, {}), model && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("div", __assign({ className: "editor__header__container" }, { children: (0, jsx_runtime_1.jsx)("div", __assign({ className: "editor__header__content" }, { children: (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light, isFilled: false }, { children: (0, jsx_runtime_1.jsx)(molecules_1.EditorHeader, { modelName: modelName, modelIndex: modelIndex, miningSchema: miningSchema, output: output, validateOutputFieldName: validateOutputName, deleteOutputField: onDeleteOutputField, commitOutputField: onUpdateOutputField, commitModelName: onUpdateModelName }) })) })) })), (0, jsx_runtime_1.jsx)("div", __assign({ className: "editor__body__container" }, { children: (0, jsx_runtime_1.jsxs)("div", __assign({ className: "editor__body__content" }, { children: [(0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ isFilled: false, "data-ouia-component-id": "model-setup" }, { children: (0, jsx_runtime_1.jsx)(organisms_1.CorePropertiesTable, { modelIndex: modelIndex, isScorable: (_a = model.isScorable) !== null && _a !== void 0 ? _a : true, functionName: model.functionName, algorithmName: model.algorithmName, baselineScore: model.baselineScore, isBaselineScoreDisabled: isBaselineScoreDisabled, baselineMethod: (_b = model.baselineMethod) !== null && _b !== void 0 ? _b : "other", initialScore: model.initialScore, areReasonCodesUsed: (_c = model.useReasonCodes) !== null && _c !== void 0 ? _c : true, reasonCodeAlgorithm: (_d = model.reasonCodeAlgorithm) !== null && _d !== void 0 ? _d : "pointsBelow", commit: onUpdateCoreProperty }) })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ isFilled: true, style: { paddingTop: "0px" } }, { children: (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({ variant: Page_1.PageSectionVariants.light, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(organisms_1.CharacteristicsContainer, { modelIndex: modelIndex, areReasonCodesUsed: (_e = model.useReasonCodes) !== null && _e !== void 0 ? _e : true, scorecardBaselineScore: model.baselineScore, characteristics: (_f = characteristics === null || characteristics === void 0 ? void 0 : characteristics.Characteristic) !== null && _f !== void 0 ? _f : [] }) })) }))] })) }))] }))] })));
};
exports.ScorecardEditorPage = ScorecardEditorPage;
//# sourceMappingURL=ScorecardEditorPage.js.map