"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsTable = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var molecules_1 = require("../molecules");
var Operation_1 = require("../Operation");
var react_redux_1 = require("react-redux");
var OperationContext_1 = require("../OperationContext");
var CharacteristicsTable = function (props) {
    var modelIndex = props.modelIndex, areReasonCodesUsed = props.areReasonCodesUsed, scorecardBaselineScore = props.scorecardBaselineScore, characteristics = props.characteristics, characteristicsUnfilteredLength = props.characteristicsUnfilteredLength, selectedCharacteristicIndex = props.selectedCharacteristicIndex, setSelectedCharacteristicIndex = props.setSelectedCharacteristicIndex, validateCharacteristicName = props.validateCharacteristicName, viewAttribute = props.viewAttribute, deleteCharacteristic = props.deleteCharacteristic, onAddAttribute = props.onAddAttribute, onCommitAndClose = props.onCommitAndClose, onCommit = props.onCommit, onCancel = props.onCancel;
    var addCharacteristicRowRef = (0, react_1.useRef)(null);
    var _a = __read((0, react_1.useState)(undefined), 2), characteristicFocusIndex = _a[0], setCharacteristicFocusIndex = _a[1];
    var _b = (0, OperationContext_1.useOperation)(), activeOperation = _b.activeOperation, setActiveOperation = _b.setActiveOperation;
    var dataFields = (0, react_redux_1.useSelector)(function (state) {
        return state.DataDictionary.DataField;
    });
    (0, react_1.useEffect)(function () {
        if (activeOperation === Operation_1.Operation.UPDATE_CHARACTERISTIC && addCharacteristicRowRef.current) {
            addCharacteristicRowRef.current.scrollIntoView({ behavior: "smooth" });
        }
    }, [activeOperation]);
    (0, react_1.useEffect)(function () {
        if (selectedCharacteristicIndex === characteristicsUnfilteredLength) {
            setSelectedCharacteristicIndex(undefined);
            setActiveOperation(Operation_1.Operation.NONE);
        }
    }, [characteristics, selectedCharacteristicIndex]);
    (0, react_1.useEffect)(function () {
        var _a;
        if (characteristicFocusIndex !== undefined) {
            (_a = document.querySelector("#characteristic-n".concat(characteristicFocusIndex))) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [characteristics, characteristicFocusIndex]);
    var onEdit = function (index) {
        setSelectedCharacteristicIndex(index);
        setActiveOperation(Operation_1.Operation.UPDATE_CHARACTERISTIC);
    };
    var handleDelete = function (index, interaction) {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setCharacteristicFocusIndex(index);
        }
        setSelectedCharacteristicIndex(undefined);
    };
    var onDelete = function (index) {
        if (index !== undefined) {
            setActiveOperation(Operation_1.Operation.NONE);
            deleteCharacteristic(index);
        }
    };
    var onValidateCharacteristicName = function (index, name) {
        return validateCharacteristicName(index, name);
    };
    return ((0, jsx_runtime_1.jsx)(Form_1.Form, __assign({ "data-testid": "characteristics-table", onSubmit: function (e) {
            e.stopPropagation();
            e.preventDefault();
        }, className: "characteristics-container__overview__form" }, { children: characteristics.map(function (ic) {
            var isRowInEditMode = selectedCharacteristicIndex === ic.index && activeOperation === Operation_1.Operation.UPDATE_CHARACTERISTIC;
            return ((0, jsx_runtime_1.jsxs)("article", __assign({ className: "editable-item characteristic-item-n".concat(selectedCharacteristicIndex, " ").concat(isRowInEditMode ? "editable-item--editing" : "") }, { children: [isRowInEditMode && ((0, jsx_runtime_1.jsx)("div", __assign({ ref: addCharacteristicRowRef }, { children: (0, jsx_runtime_1.jsx)(molecules_1.CharacteristicsTableEditRow, { modelIndex: modelIndex, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristic: ic, validateCharacteristicName: function (_name) { return onValidateCharacteristicName(ic.index, _name); }, viewAttribute: viewAttribute, onAddAttribute: onAddAttribute, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) }))), !isRowInEditMode && ((0, jsx_runtime_1.jsx)(molecules_1.CharacteristicsTableRow, { modelIndex: modelIndex, characteristicIndex: ic.index, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristic: ic, dataFields: dataFields, onEdit: function () { return onEdit(ic.index); }, onDelete: function (interaction) { return handleDelete(ic.index, interaction); } }))] }), ic.index));
        }) })));
};
exports.CharacteristicsTable = CharacteristicsTable;
//# sourceMappingURL=CharacteristicsTable.js.map