"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var PredicateEditor_1 = require("./PredicateEditor");
var Operation_1 = require("../Operation");
var react_redux_1 = require("react-redux");
var lodash_1 = require("lodash");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var OperationContext_1 = require("../OperationContext");
var organisms_1 = require("../organisms");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
require("./AttributeEditor.scss");
var atoms_1 = require("../../EditorCore/atoms");
var set = Reflect.set;
var get = Reflect.get;
var AttributeEditor = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, attributeIndex = props.attributeIndex, areReasonCodesUsed = props.areReasonCodesUsed, onCancel = props.onCancel, onCommit = props.onCommit;
    var _a = __read((0, react_1.useState)(), 2), text = _a[0], setText = _a[1];
    var _b = __read((0, react_1.useState)(), 2), partialScore = _b[0], setPartialScore = _b[1];
    var _c = __read((0, react_1.useState)(), 2), reasonCode = _c[0], setReasonCode = _c[1];
    var _d = __read((0, react_1.useState)(), 2), originalText = _d[0], setOriginalText = _d[1];
    var activeOperation = (0, OperationContext_1.useOperation)().activeOperation;
    var dataFields = (0, react_redux_1.useSelector)(function (state) {
        return state.DataDictionary.DataField;
    });
    var characteristic = (0, react_redux_1.useSelector)(function (state) {
        var model = state.models ? state.models[modelIndex] : undefined;
        if (model instanceof pmml_editor_marshaller_1.Scorecard && characteristicIndex !== undefined) {
            return model.Characteristics.Characteristic[characteristicIndex];
        }
    });
    var attribute = (0, react_1.useMemo)(function () {
        return characteristic && attributeIndex !== undefined
            ? characteristic.Attribute[attributeIndex]
            : new pmml_editor_marshaller_1.Attribute({});
    }, [characteristic, attributeIndex]);
    var commit = function (partial) {
        var existingPartial = {};
        Object.keys(partial).forEach(function (key) { return set(existingPartial, key, get(attribute, key)); });
        if (!(0, lodash_1.isEqual)(partial, existingPartial)) {
            onCommit(attributeIndex, __assign(__assign({}, attribute), partial));
        }
    };
    var ref = (0, react_cool_onclickoutside_1.default)(function () {
        if (text !== originalText) {
            commit({ predicate: (0, organisms_1.fromText)(text) });
        }
    }, {
        disabled: activeOperation !== Operation_1.Operation.UPDATE_ATTRIBUTE,
        eventTypes: ["mousedown"],
    });
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var reasonCodeValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forReasonCode()
            .build());
    }, [modelIndex, characteristicIndex, areReasonCodesUsed, attribute.reasonCode]);
    var partialScoreValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPartialScore()
            .build());
    }, [modelIndex, characteristicIndex, attribute.partialScore]);
    var predicateValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forAttribute(attributeIndex)
            .forPredicate()
            .build());
    }, [modelIndex, characteristicIndex, attribute.predicate]);
    (0, react_1.useEffect)(function () {
        var _text = (0, organisms_1.toText)(attribute.predicate, dataFields);
        setText(_text);
        setPartialScore(attribute.partialScore);
        setReasonCode(attribute.reasonCode);
        setOriginalText(_text);
    }, [modelIndex, characteristicIndex, attributeIndex, attribute.predicate]);
    var toNumber = function (value) {
        if (value === "") {
            return undefined;
        }
        var n = Number(value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    return ((0, jsx_runtime_1.jsx)("article", __assign({ tabIndex: 0, "data-ouia-component-id": "edit-attribute" }, { children: (0, jsx_runtime_1.jsx)(Form_1.Form, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Predicate", isRequired: true, fieldId: "attribute-predicate-helper", validated: predicateValidation.length > 0 ? "warning" : "default" }, { children: (0, jsx_runtime_1.jsxs)("div", __assign({ ref: ref, "data-ouia-component-id": "predicate" }, { children: [(0, jsx_runtime_1.jsx)(PredicateEditor_1.PredicateEditor, { text: text, setText: setText }), (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [predicateValidation.length > 0 && ((0, jsx_runtime_1.jsxs)("div", { children: [(0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicator, { validations: predicateValidation }), (0, jsx_runtime_1.jsx)("span", __assign({ className: "pf-c-form__helper-text pf-m-warning attribute-editor__validation-message" }, { children: predicateValidation[0].message }))] })), predicateValidation.length === 0 && ((0, jsx_runtime_1.jsx)("div", __assign({ className: "pf-c-form__helper-text" }, { children: "The condition upon which the mapping between input attribute and partial score takes place." })))] })] })) })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Reason code", fieldId: "attribute-reason-code-helper", validated: reasonCodeValidation.length > 0 ? "warning" : "default", helperText: reasonCodeValidation.length > 0
                                            ? reasonCodeValidation[0].message
                                            : "A Reason Code is mapped to a Business reason.", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: areReasonCodesUsed && (characteristic === null || characteristic === void 0 ? void 0 : characteristic.reasonCode) !== undefined
                                                ? "Reason code already provided at the Characteristic level (".concat(characteristic.reasonCode, ")")
                                                : "When Use Reason Codes is set to yes in the Model Setup, a reason code must be provided                               for characteristics or it must be provided for all its attributes." }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Partial Score", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "attribute-reason-code", name: "attribute-reason-code", "aria-describedby": "attribute-reason-code-helper", value: reasonCode !== null && reasonCode !== void 0 ? reasonCode : "", onChange: function (e) { return setReasonCode(e); }, onBlur: function () {
                                                commit({ reasonCode: reasonCode !== "" ? reasonCode : undefined });
                                            }, validated: reasonCodeValidation.length > 0 ? "warning" : "default", isDisabled: !areReasonCodesUsed || (characteristic === null || characteristic === void 0 ? void 0 : characteristic.reasonCode) !== undefined, ouiaId: "attribute-reason-code" }) })) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Partial score", fieldId: "attribute-partial-score-helper", validated: partialScoreValidation.length > 0 ? "warning" : "default", helperText: partialScoreValidation.length > 0
                                            ? partialScoreValidation[0].message
                                            : "Defines the score points awarded to the Attribute.", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: "If one of the Attributes of a Characteristic provides a Partial score value, all the attributes are required to provide a Partial score as well." }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Partial Score", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })) }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "attribute-partial-score", name: "attribute-partial-score", "aria-describedby": "attribute-partial-score-helper", value: partialScore !== null && partialScore !== void 0 ? partialScore : "", onChange: function (e) { return setPartialScore(toNumber(e)); }, onBlur: function () {
                                                commit({
                                                    partialScore: partialScore,
                                                });
                                            }, validated: partialScoreValidation.length > 0 ? "warning" : "default", ouiaId: "attribute-partial-score" }) })) })] })) })] })) }) })));
};
exports.AttributeEditor = AttributeEditor;
//# sourceMappingURL=AttributeEditor.js.map