"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicLabels = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var CharacteristicLabel_1 = require("./CharacteristicLabel");
var validation_1 = require("../../../validation");
var atoms_1 = require("../../EditorCore/atoms");
var paths_1 = require("../../../paths");
var CharacteristicLabels = function (props) {
    var modelIndex = props.modelIndex, characteristicIndex = props.characteristicIndex, activeCharacteristic = props.activeCharacteristic, areReasonCodesUsed = props.areReasonCodesUsed, scorecardBaselineScore = props.scorecardBaselineScore;
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var reasonCodeValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forReasonCode()
            .build());
    }, [modelIndex, characteristicIndex, areReasonCodesUsed, activeCharacteristic]);
    var baselineScoreValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forBaselineScore()
            .build());
    }, [modelIndex, characteristicIndex, areReasonCodesUsed, scorecardBaselineScore, activeCharacteristic]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [areReasonCodesUsed && activeCharacteristic.reasonCode !== undefined && reasonCodeValidation.length === 0 && ((0, jsx_runtime_1.jsx)(CharacteristicLabel_1.CharacteristicLabel, { name: "Reason code", value: activeCharacteristic.reasonCode })), areReasonCodesUsed && reasonCodeValidation.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: reasonCodeValidation, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Reason code:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }) }))), activeCharacteristic.baselineScore !== undefined && baselineScoreValidation.length === 0 && ((0, jsx_runtime_1.jsx)(CharacteristicLabel_1.CharacteristicLabel, { name: "Baseline score", value: activeCharacteristic.baselineScore.toString() })), areReasonCodesUsed && activeCharacteristic.baselineScore === undefined && baselineScoreValidation.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: baselineScoreValidation, cssClass: "characteristic-list__item__label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Baseline score:" }), "\u00A0", (0, jsx_runtime_1.jsx)("em", { children: "Missing" })] }) })))] }));
};
exports.CharacteristicLabels = CharacteristicLabels;
//# sourceMappingURL=CharacteristicLabels.js.map