"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Select_1 = require("@patternfly/react-core/dist/js/components/Select");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
var DataDictionaryContainer_1 = require("../DataDictionaryContainer/DataDictionaryContainer");
var ConstraintsRangeEdit_1 = require("../ConstraintsRangeEdit/ConstraintsRangeEdit");
var ConstraintsEnumEdit_1 = require("../ConstraintsEnumEdit/ConstraintsEnumEdit");
require("./ConstraintsEdit.scss");
var ConstraintsEdit = function (props) {
    var _a, _b, _c, _d;
    var dataType = props.dataType, dataFieldIndex = props.dataFieldIndex, onSave = props.onSave;
    var _e = __read((0, react_1.useState)((_b = (_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) !== null && _b !== void 0 ? _b : ""), 2), constraintType = _e[0], setConstraintType = _e[1];
    var _f = __read((0, react_1.useState)(false), 2), typeSelectIsOpen = _f[0], setTypeSelectIsOpen = _f[1];
    var _g = (0, react_1.useMemo)(function () { return getConstraintsTypeOptions(dataType); }, [dataType]), typeOptions = _g.typeOptions, enabledTypeOptionsCount = _g.enabledTypeOptionsCount;
    var typeDescription = (0, react_1.useMemo)(function () { return getConstraintsTypeDescription(dataType); }, [dataType]);
    var _h = __read((0, react_1.useState)(((_c = dataType.constraints) === null || _c === void 0 ? void 0 : _c.type) === DataDictionaryContainer_1.ConstraintType.RANGE ? dataType.constraints.value : undefined), 2), ranges = _h[0], setRanges = _h[1];
    var _j = __read((0, react_1.useState)(((_d = dataType.constraints) === null || _d === void 0 ? void 0 : _d.type) === DataDictionaryContainer_1.ConstraintType.ENUMERATION ? dataType.constraints.value : undefined), 2), enums = _j[0], setEnums = _j[1];
    var rangeConstraintLimit = (0, react_1.useMemo)(function () { return (dataType.optype === "continuous" && dataType.isCyclic ? 1 : undefined); }, [dataType]);
    var handleTypeChange = function (event, value) {
        if (value !== constraintType) {
            setConstraintType(value);
            if (value === DataDictionaryContainer_1.ConstraintType.RANGE) {
                onSave({
                    constraints: {
                        type: DataDictionaryContainer_1.ConstraintType.RANGE,
                        value: [
                            {
                                start: {
                                    value: "",
                                    included: true,
                                },
                                end: {
                                    value: "",
                                    included: true,
                                },
                            },
                        ],
                    },
                });
            }
            if (value === DataDictionaryContainer_1.ConstraintType.ENUMERATION) {
                onSave({
                    constraints: {
                        type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                        value: [""],
                    },
                });
            }
            if (value === "") {
                onSave({
                    constraints: undefined,
                });
            }
        }
        setTypeSelectIsOpen(false);
    };
    var handleTypeToggle = function () {
        setTypeSelectIsOpen(!typeSelectIsOpen);
    };
    var handleRangeSave = function (updatedRanges) {
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    var handleRangeAdd = function () {
        var updatedRanges = __spreadArray([], __read((ranges !== null && ranges !== void 0 ? ranges : [])), false);
        updatedRanges.push({
            start: {
                value: "",
                included: true,
            },
            end: {
                value: "",
                included: true,
            },
        });
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    var handleRangeDelete = function (index) {
        var updatedRanges = __spreadArray([], __read((ranges !== null && ranges !== void 0 ? ranges : [])), false);
        updatedRanges.splice(index, 1);
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.RANGE,
                value: updatedRanges,
            },
        });
    };
    var handleEnumsChange = function (value, index) {
        var updatedEnums = __spreadArray([], __read((enums !== null && enums !== void 0 ? enums : [])), false);
        updatedEnums[index] = value;
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    var handleEnumsDelete = function (index) {
        var updatedEnums = __spreadArray([], __read((enums !== null && enums !== void 0 ? enums : [])), false);
        updatedEnums.splice(index, 1);
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    var handleAddEnum = function () {
        var updatedEnums = __spreadArray(__spreadArray([], __read((enums !== null && enums !== void 0 ? enums : [])), false), [""], false);
        onSave({
            constraints: {
                type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                value: updatedEnums,
            },
        });
    };
    var handleEnumSort = function (oldIndex, newIndex) {
        if (enums) {
            var updatedEnums = reorderArray(enums, oldIndex, newIndex);
            onSave({
                constraints: {
                    type: DataDictionaryContainer_1.ConstraintType.ENUMERATION,
                    value: updatedEnums,
                },
            });
        }
    };
    (0, react_1.useEffect)(function () {
        var _a, _b, _c, _d;
        setConstraintType((_b = (_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) !== null && _b !== void 0 ? _b : "");
        if (((_c = dataType.constraints) === null || _c === void 0 ? void 0 : _c.type) === DataDictionaryContainer_1.ConstraintType.RANGE) {
            setRanges(dataType.constraints.value);
        }
        if (((_d = dataType.constraints) === null || _d === void 0 ? void 0 : _d.type) === DataDictionaryContainer_1.ConstraintType.ENUMERATION) {
            setEnums(dataType.constraints.value);
        }
    }, [dataType.constraints]);
    return ((0, jsx_runtime_1.jsxs)("section", __assign({ className: "constraints__form" }, { children: [(0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "constraints-type", label: "Constraints Type", helperText: enabledTypeOptionsCount > 1 ? "Select the type of constraint and then fill in the required fields." : "", labelIcon: typeDescription.length > 0 ? ((0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: typeDescription }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More info for Constraints Type", onClick: function (e) { return e.preventDefault(); }, "aria-describedby": "constraints-type", className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) }))) : ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {})) }, { children: (0, jsx_runtime_1.jsx)("div", __assign({ style: { width: 300 } }, { children: (0, jsx_runtime_1.jsx)(Select_1.Select, __assign({ id: "constraints-type", variant: Select_1.SelectVariant.single, "aria-label": "Select Constraint Type", onToggle: handleTypeToggle, onSelect: handleTypeChange, selections: constraintType, isOpen: typeSelectIsOpen, placeholderText: "Select a type", isDisabled: enabledTypeOptionsCount === 1, ouiaId: "constraints-type" }, { children: typeOptions.map(function (item, index) { return ((0, jsx_runtime_1.jsx)(Select_1.SelectOption, __assign({ value: item.value, isDisabled: item.disabled, "data-ouia-component-type": "select-option" }, { children: item.label }), index)); }) })) })) })), constraintType === DataDictionaryContainer_1.ConstraintType.RANGE && ranges !== undefined && ((0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ isCompact: true, className: "constraints__card" }, { children: (0, jsx_runtime_1.jsx)(Card_1.CardBody, { children: (0, jsx_runtime_1.jsx)(ConstraintsRangeEdit_1.default, { dataFieldIndex: dataFieldIndex, ranges: ranges, onAdd: handleRangeAdd, onChange: handleRangeSave, onDelete: handleRangeDelete, countLimit: rangeConstraintLimit }) }) }))), constraintType === DataDictionaryContainer_1.ConstraintType.ENUMERATION && enums !== undefined && ((0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ isCompact: true, className: "constraints__card" }, { children: (0, jsx_runtime_1.jsx)(Card_1.CardBody, { children: (0, jsx_runtime_1.jsx)(ConstraintsEnumEdit_1.default, { dataFieldIndex: dataFieldIndex, enumerations: enums, onChange: handleEnumsChange, onDelete: handleEnumsDelete, onAdd: handleAddEnum, onSort: handleEnumSort }) }) })))] })));
};
exports.default = ConstraintsEdit;
var reorderArray = function (list, startIndex, endIndex) {
    var result = __spreadArray([], __read(list), false);
    var _a = __read(result.splice(startIndex, 1), 1), removed = _a[0];
    result.splice(endIndex, 0, removed);
    return result;
};
var getConstraintsTypeOptions = function (dataType) {
    var typeOptions = [
        { value: DataDictionaryContainer_1.ConstraintType.NONE, label: "Select a type", disabled: false },
        { value: DataDictionaryContainer_1.ConstraintType.RANGE, label: "Interval", disabled: false },
        { value: DataDictionaryContainer_1.ConstraintType.ENUMERATION, label: "Value", disabled: false },
    ];
    if (dataType.type === "string" && dataType.optype === "ordinal") {
        typeOptions[0].disabled = true;
        typeOptions[1].disabled = true;
    }
    if (dataType.optype !== "continuous") {
        typeOptions[1].disabled = true;
    }
    if (dataType.isCyclic) {
        typeOptions[0].disabled = true;
    }
    var enabledTypeOptionsCount = typeOptions.filter(function (option) { return !option.disabled; }).length;
    return { typeOptions: typeOptions, enabledTypeOptionsCount: enabledTypeOptionsCount };
};
var getConstraintsTypeDescription = function (dataType) {
    if (dataType.optype === "ordinal" && dataType.isCyclic) {
        return "Cyclic ordinal data types must have Value constraints";
    }
    if (dataType.optype === "continuous" && dataType.isCyclic) {
        return "Cyclic continuous data types must have constraints";
    }
    if (dataType.type === "string" && dataType.optype === "ordinal") {
        return "Ordinal strings must have Value constraints";
    }
    if (dataType.optype !== "continuous") {
        return "Only continuous data types can have Interval constraints";
    }
    return "";
};
//# sourceMappingURL=ConstraintsEdit.js.map