"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useSwfTextEditorChannelApi = void 0;
var channel_1 = require("@kie-tools-core/editor/dist/channel");
var embedded_1 = require("@kie-tools-core/editor/dist/embedded");
var hooks_1 = require("@kie-tools-core/envelope-bus/dist/hooks");
var react_1 = require("react");
var channel_2 = require("../../channel");
var ServerlessWorkflowTextEditorChannelApiImpl_1 = require("../../channel/ServerlessWorkflowTextEditorChannelApiImpl");
function useSwfTextEditorChannelApi(args) {
    var _a, _b, _c;
    var _d = __read((0, hooks_1.useSharedValue)((_a = args.channelApi) === null || _a === void 0 ? void 0 : _a.shared.kogitoSwfServiceCatalog_services), 1), services = _d[0];
    var _e = __read((0, hooks_1.useSharedValue)((_b = args.channelApi) === null || _b === void 0 ? void 0 : _b.shared.kogitoSwfServiceCatalog_serviceRegistriesSettings), 1), serviceRegistriesSettings = _e[0];
    var stateControl = (0, react_1.useMemo)(function () { return new channel_1.StateControl(); }, [(_c = args.embeddedEditorFile) === null || _c === void 0 ? void 0 : _c.getFileContents]);
    var channelApiImpl = (0, react_1.useMemo)(function () {
        return args.embeddedEditorFile &&
            new embedded_1.EmbeddedEditorChannelApiImpl(stateControl, args.embeddedEditorFile, args.locale, __assign({}, args.apiOverrides));
    }, [args, stateControl]);
    var swfServiceCatalogChannelApiImpl = (0, react_1.useMemo)(function () {
        return args.channelApi &&
            services &&
            serviceRegistriesSettings &&
            new channel_2.SwfServiceCatalogChannelApiImpl({ channelApi: args.channelApi, services: services, serviceRegistriesSettings: serviceRegistriesSettings });
    }, [args.channelApi, serviceRegistriesSettings, services]);
    var channelApi = (0, react_1.useMemo)(function () {
        return channelApiImpl &&
            args.channelApi &&
            new ServerlessWorkflowTextEditorChannelApiImpl_1.ServerlessWorkflowTextEditorChannelApiImpl({
                defaultApiImpl: channelApiImpl,
                channelApi: args.channelApi,
                swfServiceCatalogApiImpl: swfServiceCatalogChannelApiImpl,
                diagramEditorEnvelopeApi: args.swfDiagramEditorEnvelopeApi,
            });
    }, [channelApiImpl, args, swfServiceCatalogChannelApiImpl]);
    return {
        stateControl: stateControl,
        channelApi: channelApi,
    };
}
exports.useSwfTextEditorChannelApi = useSwfTextEditorChannelApi;
//# sourceMappingURL=useSwfTextEditorChannelApi.js.map