"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashbuilderViewerFactory = void 0;
var DashbuilderViewerView_1 = require("./DashbuilderViewerView");
var DashbuilderLanguageData_1 = require("../api/DashbuilderLanguageData");
var DashbuilderViewerFactory = (function () {
    function DashbuilderViewerFactory() {
    }
    DashbuilderViewerFactory.prototype.createEditor = function (ctx, initArgs) {
        return __awaiter(this, void 0, void 0, function () {
            var langData;
            return __generator(this, function (_a) {
                appendLoaderContainer();
                langData = (0, DashbuilderLanguageData_1.getDashbuilderLanguageData)(initArgs.resourcesPathPrefix);
                langData.resources.forEach(function (resource) { return loadResource(resource); });
                return [2, new DashbuilderViewerView_1.DashbuilderViewerView(ctx, initArgs)];
            });
        });
    };
    return DashbuilderViewerFactory;
}());
exports.DashbuilderViewerFactory = DashbuilderViewerFactory;
var appendLoaderContainer = function () {
    var loaderContainer = document.createElement("div");
    var loaderDiv = document.createElement("div");
    loaderContainer.id = "loading";
    loaderContainer.className = "loader_container";
    loaderDiv.className = "db_loader";
    loaderContainer.appendChild(loaderDiv);
    document.body.appendChild(loaderContainer);
};
var loadResource = function (resource) {
    var e_1, _a;
    switch (resource.type) {
        case "css":
            try {
                for (var _b = __values(resource.paths), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var sheet = _c.value;
                    var link = document.createElement("link");
                    link.href = sheet;
                    link.rel = "text/css";
                    document.head.appendChild(link);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return Promise.resolve();
        case "js":
            return recursivelyLoadScriptsStartingFrom(resource.paths, 0);
    }
};
var recursivelyLoadScriptsStartingFrom = function (urls, i) {
    if (i >= urls.length) {
        return Promise.resolve();
    }
    return new Promise(function (res) {
        var script = document.createElement("script");
        script.type = "text/javascript";
        script.async = true;
        script.src = urls[i];
        script.addEventListener("load", function () { return recursivelyLoadScriptsStartingFrom(urls, i + 1).then(res); }, false);
        document.head.appendChild(script);
    });
};
//# sourceMappingURL=DashbuilderViewerFactory.js.map