import { useEffect, useRef } from "react";
export function useEffectAfterFirstRender(effect, b) {
    var didMountRef = useRef(false);
    useEffect(function () {
        if (didMountRef.current) {
            return effect();
        }
        didMountRef.current = true;
    }, b);
}
//# sourceMappingURL=useEffectAfterFirstRender.js.map