import { DmnLatestModel } from "@kie-tools/dmn-marshaller";
import { DMN15__tImport } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import * as RF from "reactflow";
import { ExternalModelsIndex } from "../DmnEditor";
import { DmnDiagramNodeData } from "../diagram/nodes/Nodes";
import { Normalized } from "../normalization/normalize";
import { ComputedStateCache } from "./ComputedStateCache";
import { computeAllFeelVariableUniqueNames } from "./computed/computeAllFeelVariableUniqueNames";
import { computeDataTypes } from "./computed/computeDataTypes";
import { computeDiagramData } from "./computed/computeDiagramData";
import { computeExternalModelsByType } from "./computed/computeExternalModelsByType";
import { computeIndexedDrd } from "./computed/computeIndexes";
export interface DmnEditorDiagramNodeStatus {
    selected: boolean;
    dragging: boolean;
    resizing: boolean;
}
export interface DmnEditorDiagramEdgeStatus {
    selected: boolean;
    draggingWaypoint: boolean;
}
export interface DmnEditorDiagramDividerLineStatus {
    moving: boolean;
}
export interface SnapGrid {
    isEnabled: boolean;
    x: number;
    y: number;
}
export declare enum DiagramLhsPanel {
    NONE = "NONE",
    DRD_SELECTOR = "DRD_SELECTOR",
    DRG_NODES = "DRG_NODES",
    EXTERNAL_NODES = "EXTERNAL_NODES"
}
export declare type DropTargetNode = undefined | RF.Node<DmnDiagramNodeData>;
export interface State {
    dispatch: (s: State) => Dispatch;
    computed: (s: State) => Computed;
    dmn: {
        model: Normalized<DmnLatestModel>;
    };
    focus: {
        consumableId: string | undefined;
    };
    boxedExpressionEditor: {
        activeDrgElementId: string | undefined;
        selectedObjectId: string | undefined;
        propertiesPanel: {
            isOpen: boolean;
        };
    };
    dataTypesEditor: {
        activeItemDefinitionId: string | undefined;
        expandedItemComponentIds: string[];
    };
    navigation: {
        tab: DmnEditorTab;
    };
    diagram: {
        autoLayout: {
            canAutoGenerateDrd: boolean;
        };
        __unsafeDrdIndex: number;
        edgeIdBeingUpdated: string | undefined;
        dropTargetNode: DropTargetNode;
        ongoingConnection: RF.OnConnectStartParams | undefined;
        propertiesPanel: {
            isOpen: boolean;
            elementId: string | undefined;
        };
        overlaysPanel: {
            isOpen: boolean;
        };
        openLhsPanel: DiagramLhsPanel;
        overlays: {
            enableNodeHierarchyHighlight: boolean;
            enableExecutionHitsHighlights: boolean;
            enableDataTypesToolbarOnNodes: boolean;
            enableCustomNodeStyles: boolean;
        };
        snapGrid: SnapGrid;
        _selectedNodes: Array<string>;
        _selectedEdges: Array<string>;
        draggingNodes: Array<string>;
        resizingNodes: Array<string>;
        draggingWaypoints: Array<string>;
        movingDividerLines: Array<string>;
        isEditingStyle: boolean;
    };
}
export declare type Computed = {
    isDiagramEditingInProgress(): boolean;
    importsByNamespace(): Map<string, DMN15__tImport>;
    indexedDrd(): ReturnType<typeof computeIndexedDrd>;
    getDiagramData(e: ExternalModelsIndex | undefined): ReturnType<typeof computeDiagramData>;
    isAlternativeInputDataShape(): boolean;
    isDropTargetNodeValidForSelection(e: ExternalModelsIndex | undefined): boolean;
    getExternalModelTypesByNamespace: (e: ExternalModelsIndex | undefined) => ReturnType<typeof computeExternalModelsByType>;
    getDrdIndex(): number;
    getDataTypes(e: ExternalModelsIndex | undefined): ReturnType<typeof computeDataTypes>;
    getAllFeelVariableUniqueNames(): ReturnType<typeof computeAllFeelVariableUniqueNames>;
};
export declare type Dispatch = {
    dmn: {
        reset: (model: State["dmn"]["model"]) => void;
    };
    boxedExpressionEditor: {
        open: (id: string) => void;
        close: () => void;
    };
    diagram: {
        setNodeStatus: (nodeId: string, status: Partial<DmnEditorDiagramNodeStatus>) => void;
        setEdgeStatus: (edgeId: string, status: Partial<DmnEditorDiagramEdgeStatus>) => void;
        setDividerLineStatus: (decisionServiceId: string, status: Partial<DmnEditorDiagramDividerLineStatus>) => void;
    };
};
export declare enum DmnEditorTab {
    EDITOR = 0,
    DATA_TYPES = 1,
    INCLUDED_MODELS = 2
}
export declare const defaultStaticState: () => Omit<State, "dmn" | "dispatch" | "computed">;
export declare function createDmnEditorStore(model: DmnLatestModel, computedCache: ComputedStateCache<Computed>): import("zustand").UseBoundStore<import("zustand/middleware/immer").WithImmer<import("zustand").StoreApi<State>>>;
//# sourceMappingURL=Store.d.ts.map