var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import { useState, useMemo, useCallback, useEffect, useRef } from "react";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { CubeIcon } from "@patternfly/react-icons/dist/js/icons/cube-icon";
import { PropertiesPanelHeader } from "./PropertiesPanelHeader";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { addOrGetDrd } from "../mutations/addOrGetDrd";
import { ArrowsAltVIcon } from "@patternfly/react-icons/dist/js/icons/arrows-alt-v-icon";
import { ArrowsAltHIcon } from "@patternfly/react-icons/dist/js/icons/arrows-alt-h-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import UndoAltIcon from "@patternfly/react-icons/dist/js/icons/undo-alt-icon";
import { ColorPicker } from "./ColorPicker";
import { ToggleGroup, ToggleGroupItem } from "@patternfly/react-core/dist/js/components/ToggleGroup";
import "./ShapeOptions.css";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
var DEFAULT_FILL_COLOR = { "@_blue": 255, "@_green": 255, "@_red": 255 };
var DEFAULT_STROKE_COLOR = { "@_blue": 0, "@_green": 0, "@_red": 0 };
export function ShapeOptions(_a) {
    var startExpanded = _a.startExpanded, nodeIds = _a.nodeIds, isDimensioningEnabled = _a.isDimensioningEnabled, isPositioningEnabled = _a.isPositioningEnabled;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var shapes = useDmnEditorStore(function (s) {
        return nodeIds.map(function (nodeId) { return s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId); });
    });
    var nodesById = useDmnEditorStore(function (s) { return s.computed(s).getDiagramData(externalModelsByNamespace).nodesById; });
    var shapeStyles = useMemo(function () { return shapes.map(function (shape) { return shape === null || shape === void 0 ? void 0 : shape["di:Style"]; }); }, [shapes]);
    var shapeBound = useMemo(function () { var _a; return (_a = shapes[0]) === null || _a === void 0 ? void 0 : _a["dc:Bounds"]; }, [shapes]);
    var boundWidth = useMemo(function () { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_width"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    var boundHeight = useMemo(function () { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_height"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    var boundPositionX = useMemo(function () { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_x"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    var boundPositionY = useMemo(function () { var _a, _b; return +((_b = (_a = shapeBound === null || shapeBound === void 0 ? void 0 : shapeBound["@_y"]) === null || _a === void 0 ? void 0 : _a.toFixed(2)) !== null && _b !== void 0 ? _b : ""); }, [shapeBound]);
    var _b = __read(useState(boundWidth), 2), width = _b[0], setWidth = _b[1];
    var _c = __read(useState(boundHeight), 2), height = _c[0], setHeight = _c[1];
    var previousNodeId = useRef(nodeIds[0]);
    useEffect(function () {
        setWidth(boundWidth);
        previousNodeId.current = nodeIds[0];
    }, [boundWidth, nodeIds]);
    useEffect(function () {
        setHeight(boundHeight);
        previousNodeId.current = nodeIds[0];
    }, [boundHeight, nodeIds]);
    var fillColor = useMemo(function () {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        var b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:FillColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_FILL_COLOR["@_blue"]).toString(16);
        var g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:FillColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_FILL_COLOR["@_green"]).toString(16);
        var r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:FillColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_FILL_COLOR["@_red"]).toString(16);
        return "#".concat(r.length === 1 ? "0" + r : r).concat(g.length === 1 ? "0" + g : g).concat(b.length === 1 ? "0" + b : b);
    }, [shapeStyles]);
    var strokeColor = useMemo(function () {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        var b = ((_c = (_b = (_a = shapeStyles[0]) === null || _a === void 0 ? void 0 : _a["dmndi:StrokeColor"]) === null || _b === void 0 ? void 0 : _b["@_blue"]) !== null && _c !== void 0 ? _c : DEFAULT_STROKE_COLOR["@_blue"]).toString(16);
        var g = ((_f = (_e = (_d = shapeStyles[0]) === null || _d === void 0 ? void 0 : _d["dmndi:StrokeColor"]) === null || _e === void 0 ? void 0 : _e["@_green"]) !== null && _f !== void 0 ? _f : DEFAULT_STROKE_COLOR["@_green"]).toString(16);
        var r = ((_j = (_h = (_g = shapeStyles[0]) === null || _g === void 0 ? void 0 : _g["dmndi:StrokeColor"]) === null || _h === void 0 ? void 0 : _h["@_red"]) !== null && _j !== void 0 ? _j : DEFAULT_STROKE_COLOR["@_red"]).toString(16);
        return "#".concat(r.length === 1 ? "0" + r : r).concat(g.length === 1 ? "0" + g : g).concat(b.length === 1 ? "0" + b : b);
    }, [shapeStyles]);
    var _d = __read(useState(startExpanded), 2), isShapeSectionExpanded = _d[0], setShapeSectionExpanded = _d[1];
    var setBounds = useCallback(function (callback, nodeId) {
        dmnEditorStoreApi.setState(function (s) {
            var _a, _b, _c, _d, _e;
            var diagramElements = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            }).diagramElements;
            var index = (_d = (_c = (_b = (_a = s.computed(s).indexedDrd()) === null || _a === void 0 ? void 0 : _a.dmnShapesByHref) === null || _b === void 0 ? void 0 : _b.get(nodeId)) === null || _c === void 0 ? void 0 : _c.index) !== null && _d !== void 0 ? _d : -1;
            if (index < 0) {
                throw new Error("DMN Shape for '".concat(nodeId, "' does not exist."));
            }
            var shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[index];
            if (shape.__$$element !== "dmndi:DMNShape") {
                throw new Error("DMN Element with index ".concat(index, " is not a DMNShape."));
            }
            (_e = shape["dc:Bounds"]) !== null && _e !== void 0 ? _e : (shape["dc:Bounds"] = { "@_height": 0, "@_width": 0, "@_x": 0, "@_y": 0 });
            callback(shape["dc:Bounds"], s);
        });
    }, [dmnEditorStoreApi]);
    var onChangeWidth = useCallback(function (newWidth) {
        setWidth(+newWidth);
    }, []);
    var onBlurWidth = useCallback(function (event) {
        setBounds(function (bounds, state) {
            var node = nodesById.get(previousNodeId.current);
            var minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                snapGrid: state.diagram.snapGrid,
                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
            });
            if (parseInt(event.target.value) < minNodeSize["@_width"]) {
                bounds["@_width"] = minNodeSize["@_width"];
                setWidth(minNodeSize["@_width"]);
            }
            else {
                bounds["@_width"] = parseInt(event.target.value);
            }
        }, previousNodeId.current);
    }, [nodesById, setBounds]);
    var onChangeHeight = useCallback(function (newHeight) {
        setHeight(+newHeight);
    }, []);
    var onBlurHeight = useCallback(function (event) {
        setBounds(function (bounds, state) {
            var node = nodesById.get(previousNodeId.current);
            var minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                snapGrid: state.diagram.snapGrid,
                isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
            });
            if (parseInt(event.target.value) < minNodeSize["@_height"]) {
                bounds["@_height"] = minNodeSize["@_height"];
                setHeight(minNodeSize["@_height"]);
            }
            else {
                bounds["@_height"] = parseInt(event.target.value);
            }
        }, previousNodeId.current);
    }, [nodesById, setBounds]);
    var onChangePositionX = useCallback(function (newX) {
        setBounds(function (bounds) {
            bounds["@_x"] = +parseFloat(newX).toFixed(2);
        }, nodeIds[0]);
    }, [nodeIds, setBounds]);
    var onChangePositionY = useCallback(function (newY) {
        setBounds(function (bounds) {
            bounds["@_y"] = +parseFloat(newY).toFixed(2);
        }, nodeIds[0]);
    }, [nodeIds, setBounds]);
    var setShapeStyles = useCallback(function (callback) {
        dmnEditorStoreApi.setState(function (s) {
            var e_1, _a;
            var _b;
            var diagramElements = addOrGetDrd({
                definitions: s.dmn.model.definitions,
                drdIndex: s.computed(s).getDrdIndex(),
            }).diagramElements;
            var shapesWithMinNodeSize = nodeIds.map(function (nodeId) {
                var shape = s.computed(s).indexedDrd().dmnShapesByHref.get(nodeId);
                var node = s.computed(s).getDiagramData(externalModelsByNamespace).nodesById.get(nodeId);
                var minNodeSize = MIN_NODE_SIZES[node === null || node === void 0 ? void 0 : node.type]({
                    snapGrid: s.diagram.snapGrid,
                    isAlternativeInputDataShape: s.computed(s).isAlternativeInputDataShape(),
                });
                if (!shape) {
                    throw new Error("DMN Shape for '".concat(nodeId, "' does not exist."));
                }
                return { shape: diagramElements[shape.index], minNodeSize: minNodeSize };
            });
            var i = 0;
            try {
                for (var shapesWithMinNodeSize_1 = __values(shapesWithMinNodeSize), shapesWithMinNodeSize_1_1 = shapesWithMinNodeSize_1.next(); !shapesWithMinNodeSize_1_1.done; shapesWithMinNodeSize_1_1 = shapesWithMinNodeSize_1.next()) {
                    var shape = shapesWithMinNodeSize_1_1.value.shape;
                    if (shape.__$$element !== "dmndi:DMNShape") {
                        throw new Error("DMN Element with index ".concat(i++, " is not a DMNShape."));
                    }
                    (_b = shape["di:Style"]) !== null && _b !== void 0 ? _b : (shape["di:Style"] = { "@_id": generateUuid(), __$$element: "dmndi:DMNStyle" });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (shapesWithMinNodeSize_1_1 && !shapesWithMinNodeSize_1_1.done && (_a = shapesWithMinNodeSize_1.return)) _a.call(shapesWithMinNodeSize_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            callback(shapesWithMinNodeSize, s);
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, nodeIds]);
    var _e = __read(useState(), 2), temporaryStrokeColor = _e[0], setTemporaryStrokeColor = _e[1];
    var onChangeStrokeColor = useCallback(function (newColor) {
        setTemporaryStrokeColor(newColor.replace("#", ""));
        setShapeStyles(function (shapes, state) {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(function () {
        var timeout = setTimeout(function () {
            if (!temporaryStrokeColor) {
                return;
            }
            setTemporaryStrokeColor(undefined);
            setShapeStyles(function (shapesWithMinNodeSize, state) {
                shapesWithMinNodeSize.forEach(function (_a) {
                    var _b;
                    var _c;
                    var shape = _a.shape;
                    state.diagram.isEditingStyle = false;
                    (_b = (_c = shape["di:Style"])["dmndi:StrokeColor"]) !== null && _b !== void 0 ? _b : (_c["dmndi:StrokeColor"] = __assign({}, DEFAULT_STROKE_COLOR));
                    shape["di:Style"]["dmndi:StrokeColor"]["@_red"] = parseInt(temporaryStrokeColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:StrokeColor"]["@_green"] = parseInt(temporaryStrokeColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:StrokeColor"]["@_blue"] = parseInt(temporaryStrokeColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return function () {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryStrokeColor]);
    var _f = __read(useState(), 2), temporaryFillColor = _f[0], setTemporaryFillColor = _f[1];
    var onChangeFillColor = useCallback(function (newColor) {
        setTemporaryFillColor(newColor.replace("#", ""));
        setShapeStyles(function (shapes, state) {
            state.diagram.isEditingStyle = true;
        });
    }, [setShapeStyles]);
    useEffect(function () {
        var timeout = setTimeout(function () {
            if (!temporaryFillColor) {
                return;
            }
            setTemporaryFillColor(undefined);
            setShapeStyles(function (shapesWithMinNodeSize, state) {
                shapesWithMinNodeSize.forEach(function (_a) {
                    var _b;
                    var _c;
                    var shape = _a.shape;
                    state.diagram.isEditingStyle = false;
                    (_b = (_c = shape["di:Style"])["dmndi:FillColor"]) !== null && _b !== void 0 ? _b : (_c["dmndi:FillColor"] = __assign({}, DEFAULT_FILL_COLOR));
                    shape["di:Style"]["dmndi:FillColor"]["@_red"] = parseInt(temporaryFillColor.slice(0, 2), 16);
                    shape["di:Style"]["dmndi:FillColor"]["@_green"] = parseInt(temporaryFillColor.slice(2, 4), 16);
                    shape["di:Style"]["dmndi:FillColor"]["@_blue"] = parseInt(temporaryFillColor.slice(4, 6), 16);
                });
            });
        }, 0);
        return function () {
            clearTimeout(timeout);
        };
    }, [setShapeStyles, temporaryFillColor]);
    var onReset = useCallback(function () {
        setShapeStyles(function (shapeWithNodes) {
            shapeWithNodes.forEach(function (_a) {
                var _b, _c;
                var shape = _a.shape, minNodeSize = _a.minNodeSize;
                (_b = shape["di:Style"]) !== null && _b !== void 0 ? _b : (shape["di:Style"] = {
                    __$$element: "dmndi:DMNStyle",
                    "@_id": generateUuid(),
                    "dmndi:FillColor": __assign({}, DEFAULT_FILL_COLOR),
                    "dmndi:StrokeColor": __assign({}, DEFAULT_STROKE_COLOR),
                });
                shape["di:Style"]["dmndi:FillColor"] = __assign({}, DEFAULT_FILL_COLOR);
                shape["di:Style"]["dmndi:StrokeColor"] = __assign({}, DEFAULT_STROKE_COLOR);
                (_c = shape["dc:Bounds"]) !== null && _c !== void 0 ? _c : (shape["dc:Bounds"] = {
                    "@_width": minNodeSize["@_width"],
                    "@_height": minNodeSize["@_height"],
                    "@_x": 0,
                    "@_y": 0,
                });
                shape["dc:Bounds"]["@_width"] = minNodeSize["@_width"];
                shape["dc:Bounds"]["@_height"] = minNodeSize["@_height"];
            });
        });
    }, [setShapeStyles]);
    var strokeColorPickerRef = React.useRef(null);
    var fillColorPickerRef = React.useRef(null);
    return (_jsxs(_Fragment, { children: [_jsx(PropertiesPanelHeader, { icon: _jsx(CubeIcon, { width: 16, height: 36, style: { marginLeft: "12px" } }), expands: true, fixed: false, isSectionExpanded: isShapeSectionExpanded, toogleSectionExpanded: function () { return setShapeSectionExpanded(function (prev) { return !prev; }); }, title: "Shape", action: _jsx(Button, __assign({ variant: ButtonVariant.plain, onClick: onReset, style: { paddingBottom: 0, paddingTop: 0 }, title: "Reset shape" }, { children: _jsx(UndoAltIcon, {}) })) }), isShapeSectionExpanded && (_jsxs(FormSection, __assign({ style: { paddingLeft: "20px", marginTop: "0px", marginBottom: "16px" } }, { children: [_jsx(FormGroup, __assign({ label: "Style" }, { children: _jsxs(ToggleGroup, { children: [_jsx(Tooltip, __assign({ content: "Fill color" }, { children: _jsx(ToggleGroupItem, { className: "kie-dmn-editor--shape-options-toggle-button", text: _jsx(ColorPicker, { name: "shape-fill", icon: _jsx("div", { style: {
                                                    backgroundColor: fillColor,
                                                    width: "20px",
                                                    height: "20px",
                                                    border: "dashed 1px black",
                                                    marginBottom: "-6px",
                                                } }), color: fillColor, onChange: function (newColor) { return onChangeFillColor(newColor); }, colorPickerRef: fillColorPickerRef }), buttonId: "shape-style-toggle-group-fill-color", onClick: function () {
                                            var _a;
                                            (_a = fillColorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click();
                                        } }, "fill-color") })), _jsx(Tooltip, __assign({ content: "Stroke color" }, { children: _jsx(ToggleGroupItem, { className: "kie-dmn-editor--shape-options-toggle-button", text: _jsx(ColorPicker, { name: "shape-stroke", colorDisplay: _jsx("div", { style: {
                                                    backgroundColor: "transparent",
                                                    width: "20px",
                                                    height: "20px",
                                                    border: "solid 4px",
                                                    borderColor: strokeColor,
                                                    marginBottom: "-6px",
                                                } }), color: strokeColor, onChange: function (newColor) { return onChangeStrokeColor(newColor); }, colorPickerRef: strokeColorPickerRef }), buttonId: "shape-style-toggle-group-stroke-color", onClick: function () {
                                            var _a;
                                            (_a = strokeColorPickerRef.current) === null || _a === void 0 ? void 0 : _a.click();
                                        } }, "stroke-color") })), _jsx(Tooltip, __assign({ content: "Width" }, { children: _jsx(ToggleGroupItem, { text: _jsxs("div", __assign({ style: {
                                                display: "flex",
                                                flexDirection: "row",
                                                alignItems: "center",
                                                justifyContent: "center",
                                                columnGap: "5px",
                                            } }, { children: [_jsx(TextInput, { "aria-label": "Width", "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-width-input", type: "number", isDisabled: isDimensioningEnabled ? false : true, value: isDimensioningEnabled ? width : undefined, placeholder: isDimensioningEnabled ? "Enter a value..." : undefined, onBlur: onBlurWidth, onChange: onChangeWidth, style: { border: "none", backgroundColor: "transparent" } }), _jsx("div", { children: _jsx(ArrowsAltHIcon, { "aria-label": "Width" }) })] })), buttonId: "shape-style-toggle-group-bound-width" }, "bound-width") })), _jsx(Tooltip, __assign({ content: "Height" }, { children: _jsx(ToggleGroupItem, { text: _jsxs("div", __assign({ style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" } }, { children: [_jsx(TextInput, { "aria-label": "Height", "data-testid": "kie-tools--dmn-editor--properties-panel-node-shape-height-input", type: "number", isDisabled: isDimensioningEnabled ? false : true, value: isDimensioningEnabled ? height : undefined, placeholder: isDimensioningEnabled ? "Enter a value..." : undefined, onBlur: onBlurHeight, onChange: onChangeHeight, style: { border: "none", backgroundColor: "transparent" } }), _jsx("div", { children: _jsx(ArrowsAltVIcon, { "aria-label": "Height" }) })] })), buttonId: "shape-style-toggle-group-bound-height" }, "bound-height") }))] }) })), isPositioningEnabled && (_jsx(FormGroup, __assign({ label: "Position" }, { children: _jsxs("div", __assign({ style: {
                                display: "grid",
                                gridTemplateColumns: "auto auto auto auto",
                                gridTemplateRows: "auto",
                                gridTemplateAreas: "\n                'position-x-label position-x-value position-y-label position-y-value'\n            ",
                                columnGap: "5px",
                                alignItems: "center",
                            } }, { children: [_jsx("div", __assign({ style: { gridArea: "position-x-value" } }, { children: _jsx(TextInput, { "aria-label": "X", type: "number", isDisabled: false, value: boundPositionX, onChange: onChangePositionX, placeholder: "Enter X value..." }) })), _jsx("div", __assign({ style: { gridArea: "position-x-label" } }, { children: _jsx("p", { children: "X" }) })), _jsx("div", __assign({ style: { gridArea: "position-y-value" } }, { children: _jsx(TextInput, { "aria-label": "Y", type: "number", isDisabled: false, value: boundPositionY, onChange: onChangePositionY, placeholder: "Enter Y value..." }) })), _jsx("div", __assign({ style: { gridArea: "position-y-label" } }, { children: _jsx("p", { children: "Y" }) }))] })) })))] })))] }));
}
//# sourceMappingURL=ShapeOptions.js.map