var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { DescriptionField, NameField, TypeRefField } from "./Fields";
import { useDmnEditor } from "../../DmnEditorContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { Text } from "@patternfly/react-core/dist/js/components/Text";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function FunctionDefinitionParameterCell(props) {
    var _a;
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    var _b = __read(useState([]), 2), isParameterExpanded = _b[0], setParameterExpaded = _b[1];
    var getAllUniqueNames = useCallback(function (s) { return new Map(); }, []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), cell.length === 0 && (_jsx(_Fragment, { children: _jsx(Text, { children: "Empty parameters list" }) })), cell.map(function (parameter, i) {
                var _a, _b, _c, _d, _e;
                return (_jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: (_a = isParameterExpanded[i]) !== null && _a !== void 0 ? _a : false, toogleSectionExpanded: function () {
                                return setParameterExpaded(function (prev) {
                                    var _a;
                                    var newExpanded = __spreadArray([], __read(prev), false);
                                    newExpanded[i] = !((_a = newExpanded[i]) !== null && _a !== void 0 ? _a : false);
                                    return newExpanded;
                                });
                            }, title: _jsxs("p", { children: ["Parameter ", _jsx("b", { children: parameter["@_name"] })] }) }), isParameterExpanded[i] && (_jsxs(_Fragment, { children: [_jsx(NameField, { isReadonly: props.isReadonly, id: parameter["@_id"], name: (_b = parameter["@_name"]) !== null && _b !== void 0 ? _b : "", getAllUniqueNames: getAllUniqueNames, onChange: function (newName) {
                                        updater(function (dmnObject) {
                                            var _a, _b;
                                            var _c;
                                            (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                            (_b = (_c = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_c[i] = { "@_id": generateUuid(), "@_name": "" });
                                            dmnObject.formalParameter[i]["@_name"] = newName;
                                        });
                                    } }), _jsx(FunctionDefinitionParameterTypeRef, { parameter: parameter, isReadonly: props.isReadonly, onTypeRefChange: function (newTypeRef) {
                                        return updater(function (dmnObject) {
                                            var _a, _b;
                                            var _c;
                                            (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                            (_b = (_c = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_c[i] = { "@_id": generateUuid(), "@_name": "" });
                                            dmnObject.formalParameter[i]["@_typeRef"] = newTypeRef;
                                        });
                                    } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_d = (_c = parameter.description) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "", expressionPath: (_e = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _e !== void 0 ? _e : [], onChange: function (newDescription) {
                                        updater(function (dmnObject) {
                                            var _a, _b, _c;
                                            var _d, _e;
                                            (_a = dmnObject.formalParameter) !== null && _a !== void 0 ? _a : (dmnObject.formalParameter = []);
                                            (_b = (_d = dmnObject.formalParameter)[i]) !== null && _b !== void 0 ? _b : (_d[i] = {
                                                "@_id": generateUuid(),
                                                "@_name": "",
                                                description: { __$$text: "" },
                                            });
                                            (_c = (_e = dmnObject.formalParameter[i]).description) !== null && _c !== void 0 ? _c : (_e.description = { __$$text: "" });
                                            dmnObject.formalParameter[i].description.__$$text = newDescription;
                                        });
                                    } })] }))] }, i));
            })] }));
}
function FunctionDefinitionParameterTypeRef(props) {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var itemDefinition = useMemo(function () {
        var _a, _b, _c, _d;
        var _e = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _e.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _e.allTopLevelItemDefinitionUniqueNames;
        return (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = props.parameter) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition;
    }, [dmnEditorStoreApi, externalModelsByNamespace, props.parameter]);
    return (_jsxs(_Fragment, { children: [_jsx(TypeRefField, { isReadonly: props.isReadonly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: props.parameter["@_typeRef"], onChange: props.onTypeRefChange }), itemDefinition && (_jsx(FormGroup, __assign({ label: "Constraint" }, { children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: true, itemDefinition: itemDefinition, editItemDefinition: function () { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) })))] }));
}
//# sourceMappingURL=FunctionDefinitionParametersCell.js.map