var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useState } from "react";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { InlineFeelNameInput } from "../../feel/InlineFeelNameInput";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { TypeRefSelector } from "../../dataTypes/TypeRefSelector";
export function ContentField(props) {
    return _jsx(TextField, __assign({}, props, { type: TextFieldType.TEXT_AREA, title: "Content", placeholder: "Enter the content..." }));
}
export function DescriptionField(props) {
    return (_jsx(TextField, __assign({}, props, { type: TextFieldType.TEXT_AREA, title: "Description", placeholder: "Enter a description..." })));
}
export function ExpressionLanguageField(props) {
    return (_jsx(TextField, __assign({}, props, { type: TextFieldType.TEXT_INPUT, title: "Expression Language", placeholder: "Enter the expression language..." })));
}
export function NameField(props) {
    return (_jsx(FormGroup, __assign({ label: props.alternativeFieldName ? props.alternativeFieldName : "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: props.id, name: props.name, isReadonly: props.isReadonly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) { var _a; return (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, newName); }, allUniqueNames: props.getAllUniqueNames }) })));
}
export function TypeRefField(props) {
    return (_jsx(FormGroup, __assign({ label: props.alternativeFieldName ? props.alternativeFieldName : "Type" }, { children: _jsx(TypeRefSelector, { heightRef: props.dmnEditorRootElementRef, typeRef: props.typeRef, isDisabled: props.isReadonly, onChange: function (newValue) { var _a; return (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, newValue); } }) })));
}
export var TextFieldType;
(function (TextFieldType) {
    TextFieldType["TEXT_AREA"] = "text-area";
    TextFieldType["TEXT_INPUT"] = "text-input";
})(TextFieldType || (TextFieldType = {}));
export function TextField(_a) {
    var _b, _c;
    var onChange = _a.onChange, props = __rest(_a, ["onChange"]);
    var _d = __read(useState(props.expressionPath), 2), expressionPath = _d[0], setExpressionPath = _d[1];
    var _e = __read(useState(props.initialValue), 2), value = _e[0], setValue = _e[1];
    var valueRef = React.useRef(props.initialValue);
    var isEditing = React.useRef(false);
    useEffect(function () {
        if (isEditing.current === false) {
            setValue(props.initialValue);
            setExpressionPath(props.expressionPath);
            valueRef.current = props.initialValue;
        }
    }, [props.initialValue, props.expressionPath]);
    useEffect(function () {
        return function () {
            if (isEditing.current === true) {
                if (props.initialValue === valueRef.current) {
                    return;
                }
                onChange === null || onChange === void 0 ? void 0 : onChange(valueRef.current, expressionPath);
                isEditing.current = false;
            }
        };
    }, [expressionPath, onChange, props.initialValue]);
    return (_jsxs(FormGroup, __assign({ label: props.title }, { children: [props.type === TextFieldType.TEXT_AREA && (_jsx(TextArea, { "aria-label": "Content", type: "text", isDisabled: props.isReadonly, value: value, onChange: function (newContent) {
                    setValue(newContent);
                    valueRef.current = newContent;
                    isEditing.current = true;
                }, onBlur: function () {
                    if (props.initialValue === value) {
                        return;
                    }
                    onChange === null || onChange === void 0 ? void 0 : onChange(value, expressionPath);
                    isEditing.current = false;
                }, placeholder: (_b = props.placeholder) !== null && _b !== void 0 ? _b : "Enter the expression content...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 })), props.type === TextFieldType.TEXT_INPUT && (_jsx(TextInput, { "aria-label": "Content", type: "text", isDisabled: props.isReadonly, value: value, onChange: function (newContent) {
                    setValue(newContent);
                    valueRef.current = newContent;
                    isEditing.current = true;
                }, onBlur: function () {
                    if (props.initialValue === value) {
                        return;
                    }
                    onChange === null || onChange === void 0 ? void 0 : onChange(value, expressionPath);
                    isEditing.current = false;
                }, placeholder: (_c = props.placeholder) !== null && _c !== void 0 ? _c : "Enter the expression content...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }))] })));
}
//# sourceMappingURL=Fields.js.map