var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { ContentField, DescriptionField, ExpressionLanguageField, NameField, TypeRefField } from "./Fields";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditor } from "../../DmnEditorContext";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function DecisionTableInputHeaderCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    var inputExpression = useMemo(function () { return cell.inputExpression; }, [cell.inputExpression]);
    var inputValues = useMemo(function () { return cell.inputValues; }, [cell.inputValues]);
    var inputExpressionItemDefinition = useMemo(function () {
        var _a, _b, _c;
        var _d = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _d.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _d.allTopLevelItemDefinitionUniqueNames;
        return (_c = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get((_a = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.itemDefinition;
    }, [dmnEditorStoreApi, externalModelsByNamespace, inputExpression]);
    var _v = __read(useState(true), 2), isInputExpressionExpanded = _v[0], setInputExpressionExpanded = _v[1];
    var _w = __read(useState(false), 2), isInputValuesExpanded = _w[0], setInputValuesExpanded = _w[1];
    var getAllUniqueNames = useCallback(function (s) { return new Map(); }, []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: selectedObjectId })) })), _jsx(DescriptionField, { isReadonly: props.isReadonly, expressionPath: (_b = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _b !== void 0 ? _b : [], initialValue: (_d = (_c = cell === null || cell === void 0 ? void 0 : cell.description) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "", onChange: function (newDescription) {
                    return updater(function (dmnObject) {
                        var _a;
                        (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                        dmnObject.description.__$$text = newDescription;
                    });
                } }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isInputExpressionExpanded, toogleSectionExpanded: function () { return setInputExpressionExpanded(function (prev) { return !prev; }); }, title: "Input Expression" }), isInputExpressionExpanded && (_jsxs(_Fragment, { children: [_jsx(NameField, { id: inputExpression["@_id"], isReadonly: props.isReadonly, name: (_f = (_e = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression.text) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : "", getAllUniqueNames: getAllUniqueNames, onChange: function (newName) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                        (_b = (_c = dmnObject.inputExpression).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                        dmnObject.inputExpression.text.__$$text = newName;
                                    });
                                } }), _jsx(TypeRefField, { isReadonly: props.isReadonly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_typeRef"], onChange: function (newTypeRef) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                        dmnObject.inputExpression["@_typeRef"] = newTypeRef;
                                        (_b = dmnObject.inputValues) !== null && _b !== void 0 ? _b : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        dmnObject.inputValues["@_typeRef"] = newTypeRef;
                                    });
                                } }), inputExpressionItemDefinition && (_jsx(FormGroup, __assign({ label: "Constraint" }, { children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadonly: true, itemDefinition: inputExpressionItemDefinition, editItemDefinition: function () { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) }))), _jsx(ExpressionLanguageField, { isReadonly: props.isReadonly, initialValue: (_g = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_expressionLanguage"]) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: function (newExpressionLanguage) {
                                    return updater(function (dmnObject) {
                                        var _a;
                                        (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                        dmnObject.inputExpression["@_expressionLanguage"] = newExpressionLanguage;
                                    });
                                } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_k = (_j = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression.description) === null || _j === void 0 ? void 0 : _j.__$$text) !== null && _k !== void 0 ? _k : "", expressionPath: (_l = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _l !== void 0 ? _l : [], onChange: function (newDescription) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                        (_b = (_c = dmnObject.inputExpression).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                        dmnObject.inputExpression.description.__$$text = newDescription;
                                    });
                                } })] }))] }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isInputValuesExpanded, toogleSectionExpanded: function () { return setInputValuesExpanded(function (prev) { return !prev; }); }, title: "Input Values" }), isInputValuesExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadonly: props.isReadonly, initialValue: (_m = inputValues === null || inputValues === void 0 ? void 0 : inputValues["@_expressionLanguage"]) !== null && _m !== void 0 ? _m : "", expressionPath: (_o = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _o !== void 0 ? _o : [], onChange: function (newExpressionLanguage) {
                                    return updater(function (dmnObject) {
                                        var _a;
                                        (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        dmnObject.inputValues["@_expressionLanguage"] = newExpressionLanguage;
                                    });
                                } }), _jsx(ContentField, { isReadonly: props.isReadonly, initialValue: (_q = (_p = inputValues === null || inputValues === void 0 ? void 0 : inputValues.text) === null || _p === void 0 ? void 0 : _p.__$$text) !== null && _q !== void 0 ? _q : "", expressionPath: (_r = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _r !== void 0 ? _r : [], onChange: function (newText) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        (_b = (_c = dmnObject.inputValues).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                        dmnObject.inputValues.text.__$$text = newText;
                                    });
                                } }), _jsx(DescriptionField, { isReadonly: props.isReadonly, initialValue: (_t = (_s = inputValues === null || inputValues === void 0 ? void 0 : inputValues.description) === null || _s === void 0 ? void 0 : _s.__$$text) !== null && _t !== void 0 ? _t : "", expressionPath: (_u = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _u !== void 0 ? _u : [], onChange: function (newDescription) {
                                    return updater(function (dmnObject) {
                                        var _a, _b;
                                        var _c;
                                        (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                        (_b = (_c = dmnObject.inputValues).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                        dmnObject.inputValues.description.__$$text = newDescription;
                                    });
                                } })] }))] })] }));
}
//# sourceMappingURL=DecisionTableInputHeaderCell.js.map