var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { renameDrgElement } from "../mutations/renameNode";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "../dataTypes/useResolvedTypeRef";
import { useCallback } from "react";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function BkmProperties(_a) {
    var _b, _c, _d;
    var bkm = _a.bkm, namespace = _a.namespace, index = _a.index;
    var setState = useDmnEditorStoreApi().setState;
    var thisDmnsNamespace = useDmnEditorStore(function (s) { return s.dmn.model.definitions["@_namespace"]; });
    var isReadonly = !!namespace && namespace !== thisDmnsNamespace;
    var dmnEditorRootElementRef = useDmnEditor().dmnEditorRootElementRef;
    var resolvedTypeRef = useResolvedTypeRef((_b = bkm.variable) === null || _b === void 0 ? void 0 : _b["@_typeRef"], namespace);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, __assign({ label: "Name" }, { children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: bkm["@_id"], name: bkm["@_name"], isReadonly: isReadonly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: function (newName) {
                        setState(function (state) {
                            renameDrgElement({
                                definitions: state.dmn.model.definitions,
                                index: index,
                                newName: newName,
                            });
                        });
                    }, allUniqueNames: useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []) }) })), _jsx(FormGroup, __assign({ label: "Data type" }, { children: _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, isDisabled: isReadonly, onChange: function (newTypeRef) {
                        setState(function (state) {
                            var _a;
                            var drgElement = state.dmn.model.definitions.drgElement[index];
                            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": bkm["@_name"] });
                            drgElement.variable["@_typeRef"] = newTypeRef;
                        });
                    } }) })), _jsx(FormGroup, __assign({ label: "Description" }, { children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadonly, value: (_c = bkm.description) === null || _c === void 0 ? void 0 : _c.__$$text, onChange: function (newDescription) {
                        setState(function (state) {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) })), _jsx(FormGroup, __assign({ label: "ID" }, { children: _jsx(ClipboardCopy, __assign({ isReadOnly: true, hoverTip: "Copy", clickTip: "Copied" }, { children: bkm["@_id"] })) })), _jsx(DocumentationLinksFormGroup, { isReadonly: isReadonly, values: (_d = bkm.extensionElements) === null || _d === void 0 ? void 0 : _d["kie:attachment"], onChange: function (newExtensionElements) {
                    setState(function (state) {
                        state.dmn.model.definitions.drgElement[index].extensionElements = {
                            "kie:attachment": newExtensionElements,
                        };
                    });
                } })] }));
}
//# sourceMappingURL=BkmProperties.js.map