import { NodeNature } from "./NodeNature";
import { addOrGetDrd } from "./addOrGetDrd";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
import { buildXmlQName } from "@kie-tools/xml-parser-ts/dist/qNames";
import { getNewDmnIdRandomizer } from "../idRandomizer/dmnIdRandomizer";
import { buildXmlHref } from "../xml/xmlHrefs";
import { EdgeDeletionMode, deleteEdge } from "./deleteEdge";
import { computeContainingDecisionServiceHrefsByDecisionHrefs } from "../store/computed/computeContainingDecisionServiceHrefsByDecisionHrefs.ts";
import { xmlHrefToQName } from "../xml/xmlHrefToQName";
export var NodeDeletionMode;
(function (NodeDeletionMode) {
    NodeDeletionMode[NodeDeletionMode["FROM_DRG_AND_ALL_DRDS"] = 0] = "FROM_DRG_AND_ALL_DRDS";
    NodeDeletionMode[NodeDeletionMode["FROM_CURRENT_DRD_ONLY"] = 1] = "FROM_CURRENT_DRD_ONLY";
})(NodeDeletionMode || (NodeDeletionMode = {}));
export function deleteNode(_a) {
    var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
    var definitions = _a.definitions, __readonly_drgEdges = _a.__readonly_drgEdges, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_nodeNature = _a.__readonly_nodeNature, __readonly_dmnObjectId = _a.__readonly_dmnObjectId, __readonly_dmnObjectNamespace = _a.__readonly_dmnObjectNamespace, __readonly_dmnObjectQName = _a.__readonly_dmnObjectQName, __readonly_externalModelTypesByNamespace = _a.__readonly_externalModelTypesByNamespace, mode = _a.mode;
    if (mode === NodeDeletionMode.FROM_CURRENT_DRD_ONLY &&
        !canRemoveNodeFromDrdOnly({
            definitions: definitions,
            __readonly_drdIndex: __readonly_drdIndex,
            __readonly_dmnObjectNamespace: __readonly_dmnObjectNamespace,
            __readonly_dmnObjectId: __readonly_dmnObjectId,
            __readonly_externalDmnsIndex: __readonly_externalModelTypesByNamespace.dmns,
        })) {
        console.warn("DMN MUTATION: Cannot hide a Decision that's contained by a Decision Service from a DRD.");
        return { deletedDmnObject: undefined, deletedDmnShapeOnCurrentDrd: undefined };
    }
    if (mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
        var nodeId_1 = buildXmlHref({
            namespace: __readonly_dmnObjectNamespace === definitions["@_namespace"] ? undefined : __readonly_dmnObjectNamespace,
            id: __readonly_dmnObjectId,
        });
        for (var i = 0; i < __readonly_drgEdges.length; i++) {
            var drgEdge = __readonly_drgEdges[i];
            if (drgEdge.sourceId === nodeId_1 || drgEdge.targetId === nodeId_1) {
                deleteEdge({
                    definitions: definitions,
                    drdIndex: __readonly_drdIndex,
                    mode: EdgeDeletionMode.FROM_DRG_AND_ALL_DRDS,
                    edge: {
                        id: drgEdge.id,
                        dmnObject: drgEdge.dmnObject,
                    },
                });
            }
        }
        var drgElements = (_b = definitions.drgElement) !== null && _b !== void 0 ? _b : [];
        for (var i = 0; i < drgElements.length; i++) {
            var drgElement = drgElements[i];
            if (drgElement.__$$element !== "decisionService") {
                continue;
            }
            drgElement.outputDecision = (_c = drgElement.outputDecision) === null || _c === void 0 ? void 0 : _c.filter(function (od) { return od["@_href"] !== nodeId_1; });
            drgElement.encapsulatedDecision = (_d = drgElement.encapsulatedDecision) === null || _d === void 0 ? void 0 : _d.filter(function (ed) { return ed["@_href"] !== nodeId_1; });
        }
    }
    var deletedDmnObject;
    if (!__readonly_dmnObjectQName.prefix) {
        if (__readonly_nodeNature === NodeNature.ARTIFACT) {
            if (mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS) {
                var nodeIndex = ((_e = definitions.artifact) !== null && _e !== void 0 ? _e : []).findIndex(function (a) { return a["@_id"] === __readonly_dmnObjectId; });
                deletedDmnObject = (_g = (_f = definitions.artifact) === null || _f === void 0 ? void 0 : _f.splice(nodeIndex, 1)) === null || _g === void 0 ? void 0 : _g[0];
            }
            else {
                throw new Error("DMN MUTATION: Can't hide an artifact node.");
            }
        }
        else if (__readonly_nodeNature === NodeNature.DRG_ELEMENT) {
            var nodeIndex = ((_h = definitions.drgElement) !== null && _h !== void 0 ? _h : []).findIndex(function (d) { return d["@_id"] === __readonly_dmnObjectId; });
            deletedDmnObject =
                mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS
                    ? (_k = (_j = definitions.drgElement) === null || _j === void 0 ? void 0 : _j.splice(nodeIndex, 1)) === null || _k === void 0 ? void 0 : _k[0]
                    : (_l = definitions.drgElement) === null || _l === void 0 ? void 0 : _l[nodeIndex];
        }
        else if (__readonly_nodeNature === NodeNature.UNKNOWN) {
        }
        else {
            throw new Error("DMN MUTATION: Unknown node nature '".concat(__readonly_nodeNature, "'."));
        }
        if (!deletedDmnObject && __readonly_nodeNature !== NodeNature.UNKNOWN) {
            throw new Error("DMN MUTATION: Can't delete DMN object that doesn't exist: ID=".concat(__readonly_dmnObjectId));
        }
    }
    var shapeDmnElementRef = buildXmlQName(__readonly_dmnObjectQName);
    var deletedDmnShapeOnCurrentDrd;
    var deletedIdsOnDmnObjectTree = deletedDmnObject
        ? getNewDmnIdRandomizer()
            .ack({ json: [deletedDmnObject], type: "DMN15__tDefinitions", attr: "drgElement" })
            .getOriginalIds()
        : new Set();
    var drdCount = ((_o = (_m = definitions["dmndi:DMNDI"]) === null || _m === void 0 ? void 0 : _m["dmndi:DMNDiagram"]) !== null && _o !== void 0 ? _o : []).length;
    for (var i = 0; i < drdCount; i++) {
        if (mode === NodeDeletionMode.FROM_CURRENT_DRD_ONLY && i !== __readonly_drdIndex) {
            continue;
        }
        var _q = addOrGetDrd({ definitions: definitions, drdIndex: i }), diagramElements = _q.diagramElements, widthsExtension = _q.widthsExtension;
        var dmnShapeIndex = (diagramElements !== null && diagramElements !== void 0 ? diagramElements : []).findIndex(function (d) { return d["@_dmnElementRef"] === shapeDmnElementRef; });
        if (dmnShapeIndex >= 0) {
            if (i === __readonly_drdIndex) {
                deletedDmnShapeOnCurrentDrd = diagramElements[dmnShapeIndex];
            }
            diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.splice(dmnShapeIndex, 1);
        }
        widthsExtension["kie:ComponentWidths"] = (_p = widthsExtension["kie:ComponentWidths"]) === null || _p === void 0 ? void 0 : _p.filter(function (w) { return !deletedIdsOnDmnObjectTree.has(w["@_dmnElementRef"]); });
    }
    repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions: definitions });
    return {
        deletedDmnObject: mode === NodeDeletionMode.FROM_DRG_AND_ALL_DRDS ? deletedDmnObject : undefined,
        deletedDmnShapeOnCurrentDrd: deletedDmnShapeOnCurrentDrd,
    };
}
export function canRemoveNodeFromDrdOnly(_a) {
    var _b, _c, _d, _e;
    var definitions = _a.definitions, __readonly_drdIndex = _a.__readonly_drdIndex, __readonly_dmnObjectNamespace = _a.__readonly_dmnObjectNamespace, __readonly_dmnObjectId = _a.__readonly_dmnObjectId, __readonly_externalDmnsIndex = _a.__readonly_externalDmnsIndex;
    var diagramElements = addOrGetDrd({ definitions: definitions, drdIndex: __readonly_drdIndex }).diagramElements;
    var dmnObjectHref = buildXmlHref({
        namespace: __readonly_dmnObjectNamespace === definitions["@_namespace"] ? undefined : __readonly_dmnObjectNamespace,
        id: __readonly_dmnObjectId,
    });
    var drgElements = definitions["@_namespace"] === __readonly_dmnObjectNamespace
        ? (_b = definitions.drgElement) !== null && _b !== void 0 ? _b : []
        : (_d = (_c = __readonly_externalDmnsIndex.get(__readonly_dmnObjectNamespace)) === null || _c === void 0 ? void 0 : _c.model.definitions.drgElement) !== null && _d !== void 0 ? _d : [];
    var containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn = computeContainingDecisionServiceHrefsByDecisionHrefs({
        thisDmnsNamespace: definitions["@_namespace"],
        drgElementsNamespace: __readonly_dmnObjectNamespace,
        drgElements: drgElements,
    });
    var containingDecisionServiceHrefs = (_e = containingDecisionServiceHrefsByDecisionHrefsRelativeToThisDmn.get(dmnObjectHref)) !== null && _e !== void 0 ? _e : [];
    var isContainedByDecisionService = containingDecisionServiceHrefs.length > 0;
    var isContainingDecisionServiceInExpandedFormPresentInTheDrd = containingDecisionServiceHrefs.some(function (dsHref) {
        return diagramElements.some(function (e) {
            var _a;
            return e.__$$element === "dmndi:DMNShape" &&
                e["@_dmnElementRef"] === xmlHrefToQName(dsHref, definitions) &&
                !((_a = e["@_isCollapsed"]) !== null && _a !== void 0 ? _a : false);
        });
    });
    return !isContainedByDecisionService || !isContainingDecisionServiceInExpandedFormPresentInTheDrd;
}
//# sourceMappingURL=deleteNode.js.map