import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export function addImport(_a) {
    var _b;
    var definitions = _a.definitions, includedModel = _a.includedModel;
    var isAlreadyUsingExplicitRelativePathNotation = includedModel.normalizedPathRelativeToThisDmn.startsWith("./") ||
        includedModel.normalizedPathRelativeToThisDmn.startsWith("../");
    var posixPathExplicitlyRelativeToThisDmn = isAlreadyUsingExplicitRelativePathNotation
        ? includedModel.normalizedPathRelativeToThisDmn
        : "./".concat(includedModel.normalizedPathRelativeToThisDmn);
    var newImport = {
        "@_id": generateUuid(),
        "@_name": includedModel.name.trim(),
        "@_importType": includedModel.xmlns,
        "@_namespace": includedModel.namespace,
        "@_locationURI": posixPathExplicitlyRelativeToThisDmn,
    };
    (_b = definitions.import) !== null && _b !== void 0 ? _b : (definitions.import = []);
    definitions.import.push(newImport);
    var index = 0;
    while (definitions["@_xmlns:included".concat(index)]) {
        index++;
    }
    definitions["@_xmlns:included".concat(index)] = includedModel.namespace;
    return newImport;
}
//# sourceMappingURL=addImport.js.map