import { DC__Bounds, DMN15__tDecision, DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { EdgeType, NodeType } from "../diagram/connections/graphStructure";
import { Normalized } from "../normalization/normalize";
export declare function addConnectedNode({ definitions, drdIndex, sourceNode, newNode, edgeType, }: {
    definitions: Normalized<DMN15__tDefinitions>;
    drdIndex: number;
    sourceNode: {
        type: NodeType;
        href: string;
        bounds: DC__Bounds;
        shapeId: string | undefined;
    };
    newNode: {
        type: NodeType;
        bounds: DC__Bounds;
    };
    edgeType: EdgeType;
}): {
    id: string;
    href: string;
};
export declare function getRequirementsFromEdge(sourceNode: {
    type: NodeType;
    href: string;
}, newEdgeId: string, edge: EdgeType): (Pick<Normalized<DMN15__tDecision>, "informationRequirement"> & Pick<Normalized<DMN15__tDecision>, "knowledgeRequirement"> & Pick<Normalized<DMN15__tDecision>, "authorityRequirement">) | undefined;
//# sourceMappingURL=addConnectedNode.d.ts.map