var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { drag } from "d3-drag";
import { select } from "d3-selection";
import * as React from "react";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import * as RF from "reactflow";
import { addTopLevelItemDefinition } from "../../mutations/addTopLevelItemDefinition";
import { renameDrgElement, renameGroupNode, updateTextAnnotation } from "../../mutations/renameNode";
import { updateDecisionServiceDividerLine } from "../../mutations/updateDecisionServiceDividerLine";
import { DmnEditorTab } from "../../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { snapShapeDimensions } from "../SnapGrid";
import { PositionalNodeHandles } from "../connections/PositionalNodeHandles";
import { containment, outgoingStructure } from "../connections/graphStructure";
import { EDGE_TYPES } from "../edges/EdgeTypes";
import { getContainmentRelationship, getDecisionServiceDividerLineLocalY } from "../maths/DmnMaths";
import { useIsHovered } from "../useIsHovered";
import { DataTypeNodePanel } from "./DataTypeNodePanel";
import { DECISION_SERVICE_COLLAPSED_DIMENSIONS, MIN_NODE_SIZES } from "./DefaultSizes";
import { EditExpressionNodePanel } from "./EditExpressionNodePanel";
import { EditableNodeLabel, useEditableNodeLabel } from "./EditableNodeLabel";
import { InfoNodePanel } from "./InfoNodePanel";
import { getNodeLabelPosition, useNodeStyle } from "./NodeStyle";
import { AlternativeInputDataNodeSvg, BkmNodeSvg, DecisionNodeSvg, DecisionServiceNodeSvg, GroupNodeSvg, InputDataNodeSvg, KnowledgeSourceNodeSvg, TextAnnotationNodeSvg, UnknownNodeSvg, } from "./NodeSvgs";
import { NODE_TYPES } from "./NodeTypes";
import { OutgoingStuffNodePanel } from "./OutgoingStuffNodePanel";
import { propsHaveSameValuesDeep } from "../memoization/memoization";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
import { NODE_LAYERS } from "../../store/computed/computeDiagramData";
export var InputDataNode = React.memo(function (_a) {
    var _b, _c, _d;
    var _e = _a.data, inputData = _e.dmnObject, shape = _e.shape, index = _e.index, dmnObjectQName = _e.dmnObjectQName, dmnObjectNamespace = _e.dmnObjectNamespace, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var _f = useEditableNodeLabel(id), isEditingLabel = _f.isEditingLabel, setEditingLabel = _f.setEditingLabel, triggerEditing = _f.triggerEditing, triggerEditingIfEnter = _f.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var _g = __read(useState(false), 2), isDataTypesPanelExpanded = _g[0], setDataTypePanelExpanded = _g[1];
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _h = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _h.isTargeted, isValidConnectionTarget = _h.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
        isAlternativeInputDataShape: isAlternativeInputDataShape,
    });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameDrgElement({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    var onTypeRefChange = useCallback(function (newTypeRef) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": inputData["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
        });
    }, [dmnEditorStoreApi, index, inputData]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var onCreateDataType = useDataTypeCreationCallbackForNodes(index, inputData["@_name"]);
    var _j = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _j.fontCssProperties, shapeStyle = _j.shapeStyle;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var isCollection = useDmnEditorStore(function (s) {
        var _a, _b, _c, _d, _e, _f;
        var _g = s
            .computed(s)
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _g.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _g.allTopLevelItemDefinitionUniqueNames;
        return ((_f = (_e = (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = inputData.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition) === null || _e === void 0 ? void 0 : _e["@_isCollection"]) !== null && _f !== void 0 ? _f : false);
    });
    var _k = __read(React.useState(0), 2), alternativeEditableNodeHeight = _k[0], setAlternativeEditableNodeHeight = _k[1];
    var alternativeSvgStyle = useMemo(function () {
        return isAlternativeInputDataShape
            ? {
                display: "flex",
                flexDirection: "column",
                outline: "none",
                "--selected-alternative-input-data-node-shape--height": "".concat(nodeDimensions.height + 20 + (isEditingLabel ? 20 : alternativeEditableNodeHeight !== null && alternativeEditableNodeHeight !== void 0 ? alternativeEditableNodeHeight : 0), "px"),
            }
            : undefined;
    }, [isAlternativeInputDataShape, nodeDimensions, isEditingLabel, alternativeEditableNodeHeight]);
    var selectedAlternativeClass = useMemo(function () { return (isAlternativeInputDataShape && selected ? "kie-dmn-editor--selected-alternative-input-data-node" : ""); }, [isAlternativeInputDataShape, selected]);
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className, " ").concat(isAlternativeInputDataShape ? "alternative" : "", " ").concat(selected ? "selected" : "") }, { children: isAlternativeInputDataShape ? (_jsx(AlternativeInputDataNodeSvg, __assign({ isCollection: isCollection }, nodeDimensions, { x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, isIcon: false }))) : (_jsx(InputDataNodeSvg, __assign({ isCollection: isCollection }, nodeDimensions, { x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor }))) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, style: alternativeSvgStyle, className: "kie-dmn-editor--input-data-node ".concat(className, " ").concat(selectedAlternativeClass), ref: ref, tabIndex: -1, "data-nodehref": id, "data-nodelabel": inputData["@_name"] }, { children: [_jsxs("div", __assign({ className: "kie-dmn-editor--node" }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.inputData].nodes, edgeTypes: outgoingStructure[NODE_TYPES.inputData].edges }), !isAlternativeInputDataShape && (_jsx(EditableNodeLabel, { id: id, namedElement: inputData, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({
                                    nodeType: type,
                                    isAlternativeInputDataShape: isAlternativeInputDataShape,
                                }), value: (_b = inputData["@_label"]) !== null && _b !== void 0 ? _b : inputData["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties })), shouldActLikeHovered && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_c = inputData["@_label"]) !== null && _c !== void 0 ? _c : inputData["@_name"], nodeShapeIndex: shape.index, isAlternativeInputDataShape: isAlternativeInputDataShape })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, variable: inputData.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onCreate: onCreateDataType, onChange: onTypeRefChange, onToggle: setDataTypePanelExpanded })] })), isAlternativeInputDataShape && _jsx("div", { style: { height: nodeDimensions.height, flexShrink: 0 } }), isAlternativeInputDataShape && (_jsx(EditableNodeLabel, { id: id, namedElement: inputData, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type, isAlternativeInputDataShape: isAlternativeInputDataShape }), value: (_d = inputData["@_label"]) !== null && _d !== void 0 ? _d : inputData["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: __assign(__assign({}, fontCssProperties), { zIndex: 2000 }), setLabelHeight: setAlternativeEditableNodeHeight }))] }))] }));
}, propsHaveSameValuesDeep);
export var DecisionNode = React.memo(function (_a) {
    var _b, _c, _d;
    var _e = _a.data, parentRfNode = _e.parentRfNode, decision = _e.dmnObject, shape = _e.shape, index = _e.index, dmnObjectQName = _e.dmnObjectQName, dmnObjectNamespace = _e.dmnObjectNamespace, hasHiddenRequirements = _e.hasHiddenRequirements, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var _f = useEditableNodeLabel(id), isEditingLabel = _f.isEditingLabel, setEditingLabel = _f.setEditingLabel, triggerEditing = _f.triggerEditing, triggerEditingIfEnter = _f.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var _g = __read(useState(false), 2), isDataTypesPanelExpanded = _g[0], setDataTypePanelExpanded = _g[1];
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _h = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _h.isTargeted, isValidConnectionTarget = _h.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameDrgElement({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    var onTypeRefChange = useCallback(function (newTypeRef) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decision["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
            if (drgElement.expression) {
                drgElement.expression["@_typeRef"] = newTypeRef;
            }
        });
    }, [decision, dmnEditorStoreApi, index]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var onCreateDataType = useDataTypeCreationCallbackForNodes(index, decision["@_name"]);
    var _j = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _j.fontCssProperties, shapeStyle = _j.shapeStyle;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var isCollection = useDmnEditorStore(function (s) {
        var _a, _b, _c, _d, _e, _f;
        var _g = s
            .computed(s)
            .getDataTypes(externalModelsByNamespace), allDataTypesById = _g.allDataTypesById, allTopLevelItemDefinitionUniqueNames = _g.allTopLevelItemDefinitionUniqueNames;
        return ((_f = (_e = (_d = allDataTypesById.get((_c = allTopLevelItemDefinitionUniqueNames.get((_b = (_a = decision.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"]) !== null && _b !== void 0 ? _b : "")) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d.itemDefinition) === null || _e === void 0 ? void 0 : _e["@_isCollection"]) !== null && _f !== void 0 ? _f : false);
    });
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(DecisionNodeSvg, __assign({ isCollection: isCollection }, nodeDimensions, { x: 0, y: 0, strokeWidth: parentRfNode ? 3 : shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements })) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ ref: ref, className: "kie-dmn-editor--node kie-dmn-editor--decision-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": decision["@_name"] }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), !isExternal && (_jsx(EditExpressionNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, id: decision["@_id"] })), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.decision].nodes, edgeTypes: outgoingStructure[NODE_TYPES.decision].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: decision, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type }), value: (_b = decision["@_label"]) !== null && _b !== void 0 ? _b : decision["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_d = (_c = decision["@_label"]) !== null && _c !== void 0 ? _c : decision["@_name"]) !== null && _d !== void 0 ? _d : "", nodeShapeIndex: shape.index })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, variable: decision.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onChange: onTypeRefChange, onCreate: onCreateDataType, onToggle: setDataTypePanelExpanded })] }))] }));
}, propsHaveSameValuesDeep);
export var BkmNode = React.memo(function (_a) {
    var _b, _c, _d;
    var _e = _a.data, bkm = _e.dmnObject, shape = _e.shape, index = _e.index, dmnObjectQName = _e.dmnObjectQName, dmnObjectNamespace = _e.dmnObjectNamespace, hasHiddenRequirements = _e.hasHiddenRequirements, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var _f = useEditableNodeLabel(id), isEditingLabel = _f.isEditingLabel, setEditingLabel = _f.setEditingLabel, triggerEditing = _f.triggerEditing, triggerEditingIfEnter = _f.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var _g = __read(useState(false), 2), isDataTypesPanelExpanded = _g[0], setDataTypePanelExpanded = _g[1];
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _h = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _h.isTargeted, isValidConnectionTarget = _h.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({ nodeType: type, snapGrid: snapGrid, shape: shape });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameDrgElement({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    var onTypeRefChange = useCallback(function (newTypeRef) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": bkm["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
            if (drgElement.encapsulatedLogic) {
                drgElement.encapsulatedLogic["@_typeRef"] = newTypeRef;
            }
        });
    }, [bkm, dmnEditorStoreApi, index]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var onCreateDataType = useDataTypeCreationCallbackForNodes(index, bkm["@_name"]);
    var _j = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _j.fontCssProperties, shapeStyle = _j.shapeStyle;
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(BkmNodeSvg, __assign({}, nodeDimensions, { x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements })) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ ref: ref, className: "kie-dmn-editor--node kie-dmn-editor--bkm-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": bkm["@_name"] }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), !isExternal && _jsx(EditExpressionNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, id: bkm["@_id"] }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.bkm].nodes, edgeTypes: outgoingStructure[NODE_TYPES.bkm].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: bkm, namedElementQName: dmnObjectQName, isEditing: isEditingLabel, setEditing: setEditingLabel, position: getNodeLabelPosition({ nodeType: type }), value: (_b = bkm["@_label"]) !== null && _b !== void 0 ? _b : bkm["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_d = (_c = bkm["@_label"]) !== null && _c !== void 0 ? _c : bkm["@_name"]) !== null && _d !== void 0 ? _d : "", nodeShapeIndex: shape.index })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && shouldActLikeHovered, variable: bkm.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onChange: onTypeRefChange, onCreate: onCreateDataType, onToggle: setDataTypePanelExpanded })] }))] }));
}, propsHaveSameValuesDeep);
export var KnowledgeSourceNode = React.memo(function (_a) {
    var _b, _c, _d;
    var _e = _a.data, knowledgeSource = _e.dmnObject, shape = _e.shape, index = _e.index, dmnObjectQName = _e.dmnObjectQName, hasHiddenRequirements = _e.hasHiddenRequirements, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var _f = useEditableNodeLabel(id), isEditingLabel = _f.isEditingLabel, setEditingLabel = _f.setEditingLabel, triggerEditing = _f.triggerEditing, triggerEditingIfEnter = _f.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _g = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _g.isTargeted, isValidConnectionTarget = _g.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameDrgElement({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var _h = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _h.fontCssProperties, shapeStyle = _h.shapeStyle;
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(KnowledgeSourceNodeSvg, __assign({}, nodeDimensions, { x: 0, y: 0, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, hasHiddenRequirements: hasHiddenRequirements })) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ ref: ref, className: "kie-dmn-editor--node kie-dmn-editor--knowledge-source-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": knowledgeSource["@_name"] }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.knowledgeSource].nodes, edgeTypes: outgoingStructure[NODE_TYPES.knowledgeSource].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: knowledgeSource, namedElementQName: dmnObjectQName, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_b = knowledgeSource["@_label"]) !== null && _b !== void 0 ? _b : knowledgeSource["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_d = (_c = knowledgeSource["@_label"]) !== null && _c !== void 0 ? _c : knowledgeSource["@_name"]) !== null && _d !== void 0 ? _d : "", nodeShapeIndex: shape.index }))] }))] }));
}, propsHaveSameValuesDeep);
export var TextAnnotationNode = React.memo(function (_a) {
    var _b, _c, _d, _e, _f, _g, _h;
    var _j = _a.data, textAnnotation = _j.dmnObject, shape = _j.shape, index = _j.index, dmnObjectQName = _j.dmnObjectQName, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var _k = useEditableNodeLabel(id), isEditingLabel = _k.isEditingLabel, setEditingLabel = _k.setEditingLabel, triggerEditing = _k.triggerEditing, triggerEditingIfEnter = _k.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _l = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _l.isTargeted, isValidConnectionTarget = _l.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    var setText = useCallback(function (newText) {
        dmnEditorStoreApi.setState(function (state) {
            updateTextAnnotation({ definitions: state.dmn.model.definitions, newText: newText, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var _m = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _m.fontCssProperties, shapeStyle = _m.shapeStyle;
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(TextAnnotationNodeSvg, __assign({}, nodeDimensions, { x: 0, y: 0, strokeColor: shapeStyle.strokeColor, strokeWidth: shapeStyle.strokeWidth, fillColor: shapeStyle.fillColor })) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ ref: ref, className: "kie-dmn-editor--node kie-dmn-editor--text-annotation-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": (_b = textAnnotation["@_label"]) !== null && _b !== void 0 ? _b : (_c = textAnnotation.text) === null || _c === void 0 ? void 0 : _c.__$$text }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && shouldActLikeHovered, nodeTypes: outgoingStructure[NODE_TYPES.textAnnotation].nodes, edgeTypes: outgoingStructure[NODE_TYPES.textAnnotation].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_d = textAnnotation["@_label"]) !== null && _d !== void 0 ? _d : (_e = textAnnotation.text) === null || _e === void 0 ? void 0 : _e.__$$text, onChange: setText, skipValidation: true, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), shouldActLikeHovered && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_h = (_f = textAnnotation["@_label"]) !== null && _f !== void 0 ? _f : (_g = textAnnotation.text) === null || _g === void 0 ? void 0 : _g.__$$text) !== null && _h !== void 0 ? _h : "", nodeShapeIndex: shape.index }))] }))] }));
}, propsHaveSameValuesDeep);
export var DecisionServiceNode = React.memo(function (_a) {
    var _b, _c, _d, _e;
    var _f = _a.data, decisionService = _f.dmnObject, shape = _f.shape, index = _f.index, dmnObjectQName = _f.dmnObjectQName, dmnObjectNamespace = _f.dmnObjectNamespace, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var isDropTarget = useDmnEditorStore(function (s) { var _a; return ((_a = s.diagram.dropTargetNode) === null || _a === void 0 ? void 0 : _a.id) === id; });
    var _g = useEditableNodeLabel(id), isEditingLabel = _g.isEditingLabel, setEditingLabel = _g.setEditingLabel, triggerEditing = _g.triggerEditing, triggerEditingIfEnter = _g.triggerEditingIfEnter;
    useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditingLabel);
    var _h = __read(useState(false), 2), isDataTypesPanelExpanded = _h[0], setDataTypePanelExpanded = _h[1];
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var _j = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _j.isTargeted, isValidConnectionTarget = _j.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameDrgElement({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    useEffect(function () {
        var onDoubleClick = function () {
            dmnEditorStoreApi.setState(function (state) {
                var _a, _b;
                state.diagram._selectedNodes = __spreadArray(__spreadArray([
                    id
                ], __read(((_a = decisionService.outputDecision) !== null && _a !== void 0 ? _a : []).map(function (od) { return od["@_href"]; })), false), __read(((_b = decisionService.encapsulatedDecision) !== null && _b !== void 0 ? _b : []).map(function (ed) { return ed["@_href"]; })), false);
            });
        };
        var r = ref.current;
        r === null || r === void 0 ? void 0 : r.addEventListener("dblclick", onDoubleClick);
        return function () {
            r === null || r === void 0 ? void 0 : r.removeEventListener("dblclick", onDoubleClick);
        };
    }, [decisionService.encapsulatedDecision, decisionService.outputDecision, dmnEditorStoreApi, id]);
    var onTypeRefChange = useCallback(function (newTypeRef) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decisionService["@_name"] });
            drgElement.variable["@_typeRef"] = newTypeRef;
        });
    }, [decisionService, dmnEditorStoreApi, index]);
    var getAllFeelVariableUniqueNames = useCallback(function (s) { return s.computed(s).getAllFeelVariableUniqueNames(); }, []);
    var dividerLineRef = useRef(null);
    var isCollapsed = (_b = shape["@_isCollapsed"]) !== null && _b !== void 0 ? _b : false;
    var onCreateDataType = useDataTypeCreationCallbackForNodes(index, decisionService["@_name"]);
    useEffect(function () {
        if (!dividerLineRef.current) {
            return;
        }
        var selection = select(dividerLineRef.current);
        var dragHandler = drag()
            .on("start", function () {
            dmnEditorStoreApi.setState(function (state) {
                return state.dispatch(state).diagram.setDividerLineStatus(id, { moving: true });
            });
        })
            .on("drag", function (e) {
            dmnEditorStoreApi.setState(function (state) {
                updateDecisionServiceDividerLine({
                    definitions: state.dmn.model.definitions,
                    drdIndex: state.computed(state).getDrdIndex(),
                    __readonly_dmnShapesByHref: state.computed(state).indexedDrd().dmnShapesByHref,
                    drgElementIndex: index,
                    __readonly_dmnObjectNamespace: dmnObjectNamespace,
                    __readonly_externalDmnsIndex: state
                        .computed(state)
                        .getExternalModelTypesByNamespace(externalModelsByNamespace).dmns,
                    shapeIndex: shape.index,
                    localYPosition: e.y,
                    snapGrid: state.diagram.snapGrid,
                });
            });
        })
            .on("end", function (e) {
            dmnEditorStoreApi.setState(function (state) {
                return state.dispatch(state).diagram.setDividerLineStatus(id, { moving: false });
            });
        });
        selection.call(dragHandler);
        return function () {
            selection.on(".drag", null);
        };
    }, [decisionService, dmnEditorStoreApi, dmnObjectNamespace, externalModelsByNamespace, id, index, shape.index]);
    var _k = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _k.fontCssProperties, shapeStyle = _k.shapeStyle;
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(DecisionServiceNodeSvg, __assign({ dividerLineRef: dividerLineRef, ref: ref }, nodeDimensions, { x: 0, y: 0, strokeWidth: 3, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor, isReadonly: false, isCollapsed: isCollapsed, showSectionLabels: isDropTarget, dividerLineLocalY: getDecisionServiceDividerLineLocalY(shape) })) })), _jsx(PositionalNodeHandles, { isTargeted: isTargeted && isValidConnectionTarget, nodeId: id }), _jsxs("div", __assign({ className: "kie-dmn-editor--node kie-dmn-editor--decision-service-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": decisionService["@_name"] }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && selected && !dragging }), _jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && selected && !dragging, nodeTypes: outgoingStructure[NODE_TYPES.decisionService].nodes, edgeTypes: outgoingStructure[NODE_TYPES.decisionService].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: decisionService, namedElementQName: dmnObjectQName, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_c = decisionService["@_label"]) !== null && _c !== void 0 ? _c : decisionService["@_name"], onChange: setName, onGetAllUniqueNames: getAllFeelVariableUniqueNames, shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), selected && !dragging && !isCollapsed && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_e = (_d = decisionService["@_label"]) !== null && _d !== void 0 ? _d : decisionService["@_name"]) !== null && _e !== void 0 ? _e : "", nodeShapeIndex: shape.index })), isCollapsed && _jsx("div", __assign({ className: "kie-dmn-editor--decision-service-collapsed-button" }, { children: "+" })), _jsx(DataTypeNodePanel, { isVisible: !isTargeted && selected && !dragging, variable: decisionService.variable, dmnObjectNamespace: dmnObjectNamespace, shape: shape, onCreate: onCreateDataType, onChange: onTypeRefChange, onToggle: setDataTypePanelExpanded })] }))] }));
}, propsHaveSameValuesDeep);
export var GroupNode = React.memo(function (_a) {
    var _b, _c, _d;
    var _e = _a.data, group = _e.dmnObject, shape = _e.shape, index = _e.index, dmnObjectQName = _e.dmnObjectQName, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var enableCustomNodeStyles = useDmnEditorStore(function (s) { return s.diagram.overlays.enableCustomNodeStyles; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var reactFlow = RF.useReactFlow();
    var _f = useEditableNodeLabel(id), isEditingLabel = _f.isEditingLabel, setEditingLabel = _f.setEditingLabel, triggerEditing = _f.triggerEditing, triggerEditingIfEnter = _f.triggerEditingIfEnter;
    var _g = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _g.isTargeted, isValidConnectionTarget = _g.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    var setName = useCallback(function (newName) {
        dmnEditorStoreApi.setState(function (state) {
            renameGroupNode({ definitions: state.dmn.model.definitions, newName: newName, index: index });
        });
    }, [dmnEditorStoreApi, index]);
    useEffect(function () {
        var onDoubleClick = function () {
            dmnEditorStoreApi.setState(function (state) {
                state.diagram._selectedNodes = reactFlow.getNodes().flatMap(function (n) {
                    return getContainmentRelationship({
                        bounds: n.data.shape["dc:Bounds"],
                        container: shape["dc:Bounds"],
                        snapGrid: state.diagram.snapGrid,
                        isAlternativeInputDataShape: state.computed(state).isAlternativeInputDataShape(),
                        containerMinSizes: MIN_NODE_SIZES[NODE_TYPES.group],
                        boundsMinSizes: MIN_NODE_SIZES[n.type],
                    }).isInside
                        ? [n.id]
                        : [];
                });
            });
        };
        var r = ref.current;
        r === null || r === void 0 ? void 0 : r.addEventListener("dblclick", onDoubleClick);
        return function () {
            r === null || r === void 0 ? void 0 : r.removeEventListener("dblclick", onDoubleClick);
        };
    }, [dmnEditorStoreApi, reactFlow, shape]);
    var _h = useNodeStyle({
        dmnStyle: shape["di:Style"],
        nodeType: type,
        isEnabled: enableCustomNodeStyles,
    }), fontCssProperties = _h.fontCssProperties, shapeStyle = _h.shapeStyle;
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(GroupNodeSvg, __assign({ ref: ref }, nodeDimensions, { x: 0, y: 0, strokeWidth: 3, fillColor: shapeStyle.fillColor, strokeColor: shapeStyle.strokeColor })) })), _jsxs("div", __assign({ className: "kie-dmn-editor--node kie-dmn-editor--group-node ".concat(className), tabIndex: -1, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter, "data-nodehref": id, "data-nodelabel": group["@_name"] }, { children: [_jsx(OutgoingStuffNodePanel, { nodeHref: id, isVisible: !isTargeted && selected && !dragging, nodeTypes: outgoingStructure[NODE_TYPES.group].nodes, edgeTypes: outgoingStructure[NODE_TYPES.group].edges }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: isEditingLabel, setEditing: setEditingLabel, value: (_b = group["@_label"]) !== null && _b !== void 0 ? _b : group["@_name"], onChange: setName, skipValidation: true, onGetAllUniqueNames: useCallback(function () { return new Map(); }, []), shouldCommitOnBlur: true, fontCssProperties: fontCssProperties }), selected && !dragging && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: (_d = (_c = group["@_label"]) !== null && _c !== void 0 ? _c : group["@_name"]) !== null && _d !== void 0 ? _d : "", nodeShapeIndex: shape.index }))] }))] }));
}, propsHaveSameValuesDeep);
export var UnknownNode = React.memo(function (_a) {
    var _b = _a.data, shape = _b.shape, dmnObjectQName = _b.dmnObjectQName, selected = _a.selected, dragging = _a.dragging, zIndex = _a.zIndex, type = _a.type, id = _a.id;
    var renderCount = useRef(0);
    renderCount.current++;
    var ref = useRef(null);
    var isExternal = !!dmnObjectQName.prefix;
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var isHovered = useIsHovered(ref);
    var isResizing = useNodeResizing(id);
    var shouldActLikeHovered = useDmnEditorStore(function (s) { return (isHovered || isResizing) && s.diagram.draggingNodes.length === 0; });
    var _c = useConnectionTargetStatus(id, shouldActLikeHovered), isTargeted = _c.isTargeted, isValidConnectionTarget = _c.isValidConnectionTarget;
    var className = useNodeClassName(isValidConnectionTarget, id);
    var nodeDimensions = useNodeDimensions({
        nodeType: type,
        snapGrid: snapGrid,
        shape: shape,
    });
    return (_jsxs(_Fragment, { children: [_jsx("svg", __assign({ className: "kie-dmn-editor--node-shape ".concat(className) }, { children: _jsx(UnknownNodeSvg, __assign({}, nodeDimensions, { x: 0, y: 0 })) })), _jsx(RF.Handle, { id: "unknown", type: "source", style: { opacity: 0 }, position: RF.Position.Top }, "unknown"), _jsxs("div", __assign({ ref: ref, className: "kie-dmn-editor--node kie-dmn-editor--unknown-node ".concat(className), tabIndex: -1, "data-nodehref": id }, { children: [_jsx(InfoNodePanel, { isVisible: !isTargeted && shouldActLikeHovered }), _jsx(EditableNodeLabel, { id: id, namedElement: undefined, namedElementQName: undefined, position: getNodeLabelPosition({ nodeType: type }), isEditing: false, setEditing: function () { }, value: "? ", onChange: function () { }, skipValidation: false, onGetAllUniqueNames: useCallback(function () { return new Map(); }, []), shouldCommitOnBlur: true }), selected && !dragging && (_jsx(NodeResizerHandle, { nodeType: type, snapGrid: snapGrid, nodeId: id, nodeName: "unknown", nodeShapeIndex: shape.index }))] }))] }));
}, propsHaveSameValuesDeep);
export function EmptyLabel() {
    return (_jsxs("span", __assign({ style: { fontFamily: "serif" } }, { children: [_jsx("i", __assign({ style: { opacity: 0.8 } }, { children: "<Empty>" })), _jsx("br", {}), _jsx("i", __assign({ style: { opacity: 0.5, fontSize: "0.8em", lineHeight: "0.8em" } }, { children: "Double-click to name" }))] })));
}
var resizerControlStyle = {
    background: "transparent",
    border: "none",
};
export function NodeResizerHandle(props) {
    var minSize = props.nodeType === NODE_TYPES.inputData
        ? MIN_NODE_SIZES[props.nodeType]({
            snapGrid: props.snapGrid,
            isAlternativeInputDataShape: props.isAlternativeInputDataShape,
        })
        : MIN_NODE_SIZES[props.nodeType]({
            snapGrid: props.snapGrid,
        });
    return (_jsx(RF.NodeResizeControl, __assign({ style: resizerControlStyle, minWidth: minSize["@_width"], minHeight: minSize["@_height"] }, { children: _jsx("div", { "data-testid": "kie-tools--dmn-editor--".concat(props.nodeName, "-resize-handle"), style: {
                position: "absolute",
                top: "-10px",
                left: "-10px",
                width: "12px",
                height: "12px",
                backgroundColor: "black",
                clipPath: "polygon(0 100%, 100% 100%, 100% 0)",
            } }) })));
}
function useNodeResizing(id) {
    return RF.useStore(function (s) { var _a, _b; return (_b = (_a = s.nodeInternals.get(id)) === null || _a === void 0 ? void 0 : _a.resizing) !== null && _b !== void 0 ? _b : false; });
}
function useNodeDimensions(args) {
    var nodeType = args.nodeType, snapGrid = args.snapGrid, shape = args.shape;
    var isAlternativeInputDataShape = nodeType === NODE_TYPES.inputData ? args.isAlternativeInputDataShape : false;
    return useMemo(function () {
        if (nodeType === NODE_TYPES.decisionService && shape["@_isCollapsed"]) {
            return DECISION_SERVICE_COLLAPSED_DIMENSIONS;
        }
        var minSizes = nodeType === NODE_TYPES.inputData
            ? MIN_NODE_SIZES[nodeType]({
                snapGrid: snapGrid,
                isAlternativeInputDataShape: isAlternativeInputDataShape,
            })
            : MIN_NODE_SIZES[nodeType]({
                snapGrid: snapGrid,
            });
        return {
            width: snapShapeDimensions(snapGrid, shape, minSizes).width,
            height: snapShapeDimensions(snapGrid, shape, minSizes).height,
        };
    }, [isAlternativeInputDataShape, shape, snapGrid, nodeType]);
}
function useHoveredNodeAlwaysOnTop(ref, zIndex, shouldActLikeHovered, dragging, selected, isEditing) {
    useLayoutEffect(function () {
        var r = ref.current;
        if (selected && !isEditing) {
            r === null || r === void 0 ? void 0 : r.focus();
        }
        if (r) {
            r.parentElement.style.zIndex = "".concat(shouldActLikeHovered || dragging ? zIndex + NODE_LAYERS.NESTED_NODES + 1 : zIndex);
        }
    }, [dragging, shouldActLikeHovered, ref, zIndex, selected, isEditing]);
}
export function useConnection(nodeId) {
    var connectionNodeId = RF.useStore(function (s) { return s.connectionNodeId; });
    var connectionHandleType = RF.useStore(function (s) { return s.connectionHandleType; });
    var source = connectionNodeId;
    var target = nodeId;
    var edgeIdBeingUpdated = useDmnEditorStore(function (s) { return s.diagram.edgeIdBeingUpdated; });
    var sourceHandle = RF.useStore(function (s) { var _a, _b, _c; return (_c = (_a = s.connectionHandleId) !== null && _a !== void 0 ? _a : (_b = s.edges.find(function (e) { return e.id === edgeIdBeingUpdated; })) === null || _b === void 0 ? void 0 : _b.type) !== null && _c !== void 0 ? _c : null; });
    var connection = useMemo(function () { return ({
        source: connectionHandleType === "source" ? source : target,
        target: connectionHandleType === "source" ? target : source,
        sourceHandle: sourceHandle,
        targetHandle: null,
    }); }, [connectionHandleType, source, sourceHandle, target]);
    return connection;
}
export function useConnectionTargetStatus(nodeId, shouldActLikeHovered) {
    var isTargeted = RF.useStore(function (s) { return !!s.connectionNodeId && s.connectionNodeId !== nodeId && shouldActLikeHovered; });
    var connection = useConnection(nodeId);
    var isValidConnectionTarget = RF.useStore(function (s) { var _a, _b; return (_b = (_a = s.isValidConnection) === null || _a === void 0 ? void 0 : _a.call(s, connection)) !== null && _b !== void 0 ? _b : false; });
    return useMemo(function () { return ({
        isTargeted: isTargeted,
        isValidConnectionTarget: isValidConnectionTarget,
    }); }, [isTargeted, isValidConnectionTarget]);
}
export function useNodeClassName(isValidConnectionTarget, nodeId) {
    var isDropTarget = useDmnEditorStore(function (s) { var _a, _b; return ((_a = s.diagram.dropTargetNode) === null || _a === void 0 ? void 0 : _a.id) === nodeId && containment.get((_b = s.diagram.dropTargetNode) === null || _b === void 0 ? void 0 : _b.type); });
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var isDropTargetNodeValidForSelection = useDmnEditorStore(function (s) {
        return s.computed(s).isDropTargetNodeValidForSelection(externalModelsByNamespace);
    });
    var isConnectionNodeId = RF.useStore(function (s) { return s.connectionNodeId === nodeId; });
    var connection = useConnection(nodeId);
    var isEdgeConnection = !!Object.values(EDGE_TYPES).find(function (s) { return s === connection.sourceHandle; });
    var isNodeConnection = !!Object.values(NODE_TYPES).find(function (s) { return s === connection.sourceHandle; });
    if (isNodeConnection && !isConnectionNodeId) {
        return "dimmed";
    }
    if (isEdgeConnection && (!isValidConnectionTarget || isConnectionNodeId)) {
        return "dimmed";
    }
    if (isDropTarget) {
        return isDropTargetNodeValidForSelection ? "drop-target" : "drop-target-invalid";
    }
    return "normal";
}
export function useDataTypeCreationCallbackForNodes(index, drgElementName) {
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    return useCallback(function (newDataTypeName) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var drgElement = state.dmn.model.definitions.drgElement[index];
            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": drgElementName });
            drgElement.variable["@_typeRef"] = newDataTypeName;
            var newItemDefinition = addTopLevelItemDefinition({
                definitions: state.dmn.model.definitions,
                partial: { "@_name": newDataTypeName, typeRef: undefined },
            });
            state.dataTypesEditor.activeItemDefinitionId = newItemDefinition["@_id"];
            state.navigation.tab = DmnEditorTab.DATA_TYPES;
            state.focus.consumableId = newItemDefinition["@_id"];
        });
    }, [dmnEditorStoreApi, drgElementName, index]);
}
//# sourceMappingURL=Nodes.js.map