import { useMemo } from "react";
import * as RF from "reactflow";
import { useDmnEditorStore } from "../../store/StoreContext";
import { getSnappedMultiPointAnchoredEdgePath } from "./getSnappedMultiPointAnchoredEdgePath";
export function useKieEdgePath(source, target, data) {
    var snapGrid = useDmnEditorStore(function (s) { return s.diagram.snapGrid; });
    var sourceNodeX = RF.useStore(function (s) { var _a, _b; return (source ? (_b = (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.x : undefined); });
    var sourceNodeY = RF.useStore(function (s) { var _a, _b; return (source ? (_b = (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.y : undefined); });
    var sourceNodeWidth = RF.useStore(function (s) { var _a; return (source ? (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.width : undefined); });
    var sourceNodeHeight = RF.useStore(function (s) { var _a; return (source ? (_a = s.nodeInternals.get(source)) === null || _a === void 0 ? void 0 : _a.height : undefined); });
    var targetNodeX = RF.useStore(function (s) { var _a, _b; return (target ? (_b = (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.x : undefined); });
    var targetNodeY = RF.useStore(function (s) { var _a, _b; return (target ? (_b = (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.positionAbsolute) === null || _b === void 0 ? void 0 : _b.y : undefined); });
    var targetNodeWidth = RF.useStore(function (s) { var _a; return (target ? (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.width : undefined); });
    var targetNodeHeight = RF.useStore(function (s) { var _a; return (target ? (_a = s.nodeInternals.get(target)) === null || _a === void 0 ? void 0 : _a.height : undefined); });
    var dmnEdge = data === null || data === void 0 ? void 0 : data.dmnEdge;
    var dmnShapeSource = data === null || data === void 0 ? void 0 : data.dmnShapeSource;
    var dmnShapeTarget = data === null || data === void 0 ? void 0 : data.dmnShapeTarget;
    return useMemo(function () {
        return getSnappedMultiPointAnchoredEdgePath({
            snapGrid: snapGrid,
            dmnEdge: dmnEdge,
            sourceNodeBounds: { x: sourceNodeX, y: sourceNodeY, width: sourceNodeWidth, height: sourceNodeHeight },
            targetNodeBounds: { x: targetNodeX, y: targetNodeY, width: targetNodeWidth, height: targetNodeHeight },
            dmnShapeSource: dmnShapeSource,
            dmnShapeTarget: dmnShapeTarget,
        });
    }, [
        dmnEdge,
        dmnShapeSource,
        dmnShapeTarget,
        snapGrid,
        sourceNodeHeight,
        sourceNodeWidth,
        sourceNodeX,
        sourceNodeY,
        targetNodeHeight,
        targetNodeWidth,
        targetNodeX,
        targetNodeY,
    ]);
}
//# sourceMappingURL=useKieEdgePath.js.map