var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Popover, PopoverPosition } from "@patternfly/react-core/dist/js/components/Popover";
import { useMemo } from "react";
import { DMN_LATEST_VERSION } from "@kie-tools/dmn-marshaller";
var latestChangelogHref = "https://www.omg.org/spec/DMN/1.5/Beta1/PDF/changebar";
export function DmnVersionLabel(props) {
    var label = useMemo(function () { return (_jsx(Label, __assign({ style: { cursor: "pointer", position: "absolute", bottom: "8px", left: "calc(50% - 34px)", zIndex: 100 } }, { children: "DMN ".concat(DMN_LATEST_VERSION) }))); }, []);
    if (props.version === DMN_LATEST_VERSION) {
        return _jsx(_Fragment, { children: label });
    }
    return (_jsx(Popover, __assign({ className: "kie-dmn-editor--version-popover", "aria-label": "DMN version popover", position: PopoverPosition.top, headerContent: _jsx("div", { children: "Version upgraded!" }), bodyContent: _jsxs("div", { children: ["This DMN was originally imported as DMN ", props.version, ", but was converted to DMN ", DMN_LATEST_VERSION, " to enable new features.", _jsxs("a", __assign({ href: latestChangelogHref, target: "_blank" }, { children: ["\u00A0", "See what's new on DMN ".concat(DMN_LATEST_VERSION), "."] }))] }) }, { children: label })));
}
//# sourceMappingURL=DmnVersionLabel.js.map