var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useCallback } from "react";
import { ConstraintsExpression } from "./ConstraintsExpression";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { HelperText, HelperTextItem } from "@patternfly/react-core/dist/js/components/HelperText";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
var RANGE_CONSTRAINT_SEPARATOR = "..";
var CONSTRAINT_START_ID = "start";
var CONSTRAINT_END_ID = "end";
export function ConstraintsRange(_a) {
    var id = _a.id, isReadonly = _a.isReadonly, value = _a.value, expressionValue = _a.expressionValue, type = _a.type, typeHelper = _a.typeHelper, onSave = _a.onSave, isDisabled = _a.isDisabled, renderOnPropertiesPanel = _a.renderOnPropertiesPanel;
    var start = useMemo(function () { var _a, _b; return (_b = typeHelper.recover((_a = isRange(value !== null && value !== void 0 ? value : "", typeHelper.check)) === null || _a === void 0 ? void 0 : _a[0])) !== null && _b !== void 0 ? _b : ""; }, [typeHelper, value]);
    var end = useMemo(function () { var _a, _b; return (_b = typeHelper.recover((_a = isRange(value !== null && value !== void 0 ? value : "", typeHelper.check)) === null || _a === void 0 ? void 0 : _a[1])) !== null && _b !== void 0 ? _b : ""; }, [typeHelper, value]);
    var includeStart = useMemo(function () {
        if (value === undefined) {
            return true;
        }
        if (hasRangeStartStructure(value)) {
            if (value.charAt(0) === "[") {
                return true;
            }
            return false;
        }
        return true;
    }, [value]);
    var includeEnd = useMemo(function () {
        if (value === undefined) {
            return false;
        }
        if (hasRangeEndStructure(value)) {
            if (value.charAt(value.length - 1) === "]") {
                return true;
            }
            return false;
        }
        return false;
    }, [value]);
    var isStartValid = useCallback(function (args) {
        if (type === DmnBuiltInDataType.String) {
            return true;
        }
        var parsedEnd = typeHelper.parse(args.end);
        var parsedStart = typeHelper.parse(args.start);
        return args.end !== "" ? (args.includeEnd ? parsedEnd >= parsedStart : parsedEnd > parsedStart) : true;
    }, [type, typeHelper]);
    var isEndValid = useCallback(function (args) {
        if (type === DmnBuiltInDataType.String) {
            return true;
        }
        var parsedEnd = typeHelper.parse(args.end);
        var parsedStart = typeHelper.parse(args.start);
        return args.start !== "" ? (args.includeEnd ? parsedEnd >= parsedStart : parsedEnd > parsedStart) : true;
    }, [type, typeHelper]);
    var onInternalChange = useCallback(function (args) {
        var _a, _b, _c, _d;
        if (args === undefined) {
            return;
        }
        var internalStart = (_a = args === null || args === void 0 ? void 0 : args.start) !== null && _a !== void 0 ? _a : start;
        var internalEnd = (_b = args === null || args === void 0 ? void 0 : args.end) !== null && _b !== void 0 ? _b : end;
        if (internalStart === "" && internalEnd === "") {
            onSave("");
            return;
        }
        onSave("".concat(((_c = args === null || args === void 0 ? void 0 : args.includeStart) !== null && _c !== void 0 ? _c : includeStart) ? "[" : "(").concat(typeHelper.transform(internalStart), "..").concat(typeHelper.transform(internalEnd)).concat(((_d = args === null || args === void 0 ? void 0 : args.includeEnd) !== null && _d !== void 0 ? _d : includeEnd) ? "]" : ")"));
    }, [end, includeEnd, includeStart, onSave, start, typeHelper]);
    var onStartChange = useCallback(function (newStartValue) {
        onInternalChange({ start: newStartValue });
    }, [onInternalChange]);
    var onEndChange = useCallback(function (newEndValue) {
        onInternalChange({ end: newEndValue });
    }, [onInternalChange]);
    var onIncludeStartToogle = useCallback(function () {
        onInternalChange({ includeStart: !includeStart });
    }, [includeStart, onInternalChange]);
    var onIncludeEndToogle = useCallback(function () {
        onInternalChange({ includeEnd: !includeEnd });
    }, [includeEnd, onInternalChange]);
    var messages = useCallback(function (value, operator) {
        if (type === DmnBuiltInDataType.Date && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 1 Day).");
        }
        if (type === DmnBuiltInDataType.DateTime && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 1 Second).");
        }
        if (type === DmnBuiltInDataType.DateTimeDuration && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 1 Second).");
        }
        if (type === DmnBuiltInDataType.Number && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 2e-52).");
        }
        if (type === DmnBuiltInDataType.Time && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 1 Second).");
        }
        if (type === DmnBuiltInDataType.YearsMonthsDuration && value !== "") {
            return "The next valid number is: (".concat(value, " ").concat(operator, " 1 Month).");
        }
        return "";
    }, [type]);
    var onKeyDown = useCallback(function (e) {
        var _a, _b, _c, _d;
        if (e.currentTarget.value[(_a = e.currentTarget.selectionStart) !== null && _a !== void 0 ? _a : 0] === "." &&
            e.currentTarget.value[((_b = e.currentTarget.selectionStart) !== null && _b !== void 0 ? _b : 2) - 2] === "." &&
            e.key === "Backspace") {
            e.preventDefault();
        }
        if ((e.currentTarget.value[(_c = e.currentTarget.selectionStart) !== null && _c !== void 0 ? _c : 0] === "." ||
            e.currentTarget.value[((_d = e.currentTarget.selectionStart) !== null && _d !== void 0 ? _d : 1) - 1] === ".") &&
            e.key === ".") {
            e.preventDefault();
        }
    }, []);
    return (_jsxs("div", { children: [_jsxs("div", __assign({ style: {
                    display: "grid",
                    gridTemplateColumns: "auto auto 1fr",
                    gridTemplateRows: "1fr 50px 70px 1fr 50px",
                    gridTemplateAreas: "\n          'start includeStartButton startField'\n          'empty1 arrow startDescription'\n          'empty2 arrow empty3'\n          'end includeEndButton endField'\n          'empty4 empty5 endDescription'\n          ",
                    columnGap: "10px",
                    alignItems: "center",
                } }, { children: [_jsx("div", __assign({ style: { gridArea: "start" } }, { children: _jsx(Label, { children: "Start" }) })), _jsx("div", __assign({ style: { gridArea: "includeStartButton" } }, { children: _jsx(Tooltip, __assign({ content: includeStart ? "Click to remove value from the range" : "Click to include value in the range" }, { children: _jsx("button", { id: CONSTRAINT_START_ID, disabled: isReadonly || isDisabled, onClick: function () { return onIncludeStartToogle(); }, style: {
                                    borderRadius: "100%",
                                    borderColor: "rgb(90 90 90)",
                                    borderStyle: "solid",
                                    borderWidth: "2px",
                                    width: "20px",
                                    height: "20px",
                                    backgroundColor: includeStart ? "rgb(90 90 90)" : "transparent",
                                } }) })) })), _jsx("div", __assign({ style: { gridArea: "startField" } }, { children: typeHelper.component({
                            autoFocus: start === "",
                            onBlur: function () { return onInternalChange(); },
                            onChange: onStartChange,
                            id: "start-value",
                            isDisabled: isReadonly || isDisabled,
                            placeholder: "Starts with",
                            style: {
                                outline: "none",
                            },
                            value: start,
                            isValid: isStartValid({ includeEnd: includeEnd, start: start, end: end }),
                            onKeyDown: onKeyDown,
                        }) })), _jsx("div", __assign({ style: { gridArea: "startDescription" } }, { children: _jsx(HelperText, { children: _jsx(HelperTextItem, __assign({ variant: "indeterminate" }, { children: includeStart
                                    ? "The starting value will be included in the range."
                                    : "The starting value will not be included in the range. ".concat(messages(start, "+")) })) }) })), _jsx("div", __assign({ style: { gridArea: "arrow", justifySelf: "center", alignSelf: "center", height: "100%" } }, { children: _jsx("div", { style: {
                                borderLeftStyle: "solid",
                                borderLeftColor: "rgb(90 90 90)",
                                borderLeftWidth: "2px",
                                height: "calc(100% + 18px)",
                                marginTop: "-10px",
                                marginBottom: "-8px",
                            } }) })), _jsx("div", __assign({ style: { gridArea: "end" } }, { children: _jsx(Label, { children: "End" }) })), _jsx("div", __assign({ style: { gridArea: "includeEndButton" } }, { children: _jsx(Tooltip, __assign({ content: includeEnd ? "Click to remove value from the range" : "Click to include value in the range" }, { children: _jsx("button", { id: CONSTRAINT_END_ID, disabled: isReadonly || isDisabled, onClick: function () { return onIncludeEndToogle(); }, style: {
                                    borderRadius: "100%",
                                    borderColor: "rgb(90 90 90)",
                                    borderStyle: "solid",
                                    borderWidth: "2px",
                                    width: "20px",
                                    height: "20px",
                                    backgroundColor: includeEnd ? "rgb(90 90 90)" : "transparent",
                                } }) })) })), _jsx("div", __assign({ style: { gridArea: "endField" } }, { children: typeHelper.component({
                            autoFocus: start !== "",
                            onBlur: function () { return onInternalChange(); },
                            onChange: onEndChange,
                            id: "end-value",
                            isDisabled: isReadonly || isDisabled,
                            placeholder: "Ends with",
                            style: { outline: "none" },
                            value: end,
                            isValid: isEndValid({ includeEnd: includeEnd, start: start, end: end }),
                            onKeyDown: onKeyDown,
                        }) })), _jsx("div", __assign({ style: { gridArea: "endDescription" } }, { children: _jsx(HelperText, { children: _jsx(HelperTextItem, __assign({ variant: "indeterminate" }, { children: includeEnd
                                    ? "The ending value will be included in the range."
                                    : "The ending value will not be included in the range. ".concat(messages(end, "-")) })) }) }))] })), !renderOnPropertiesPanel && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx(ConstraintsExpression, { id: id, isReadonly: true, value: expressionValue !== null && expressionValue !== void 0 ? expressionValue : "", type: type })] }))] }));
}
export function hasRangeStartStructure(value) {
    return value.startsWith("(") || value.startsWith("[") || value.startsWith("]");
}
export function hasRangeEndStructure(value) {
    return value.endsWith(")") || value.endsWith("]") || value.startsWith("[");
}
export function hasRangeStructure(value) {
    return (hasRangeStartStructure(value) && hasRangeEndStructure(value) && value.split(RANGE_CONSTRAINT_SEPARATOR).length === 2);
}
export function isRange(value, typeCheck) {
    if (value === undefined) {
        return undefined;
    }
    if (!hasRangeStructure(value)) {
        return undefined;
    }
    var rangeValues = value.split(RANGE_CONSTRAINT_SEPARATOR);
    if (rangeValues.length === 2 && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(rangeValues[0].slice(1))) && (typeCheck === null || typeCheck === void 0 ? void 0 : typeCheck(rangeValues[1].slice(0, -1)))) {
        return [rangeValues[0].slice(1), rangeValues[1].slice(0, -1)];
    }
    return undefined;
}
//# sourceMappingURL=ConstraintsRange.js.map