var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { DmnBuiltInDataType, generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { BEE_TABLE_ROW_INDEX_COLUMN_WIDTH, CONTEXT_ENTRY_VARIABLE_MIN_WIDTH, DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH, DECISION_TABLE_INPUT_DEFAULT_WIDTH, DECISION_TABLE_OUTPUT_DEFAULT_WIDTH, LITERAL_EXPRESSION_MIN_WIDTH, RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH, } from "@kie-tools/boxed-expression-component/dist/resizing/WidthConstants";
import { DECISION_TABLE_INPUT_DEFAULT_VALUE, DECISION_TABLE_OUTPUT_DEFAULT_VALUE, } from "@kie-tools/boxed-expression-component/dist/expressions/DecisionTableExpression/DecisionTableExpression";
import { INVOCATION_EXPRESSION_DEFAULT_PARAMETER_NAME } from "@kie-tools/boxed-expression-component/dist/expressions/InvocationExpression/InvocationExpression";
import { RELATION_EXPRESSION_DEFAULT_VALUE } from "@kie-tools/boxed-expression-component/dist/expressions/RelationExpression/RelationExpression";
import { isStruct } from "../dataTypes/DataTypeSpec";
export function getDefaultBoxedExpression(_a) {
    var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
    var logicType = _a.logicType, typeRef = _a.typeRef, allTopLevelDataTypesByFeelName = _a.allTopLevelDataTypesByFeelName, widthsById = _a.widthsById, getInputs = _a.getInputs, getDefaultColumnWidth = _a.getDefaultColumnWidth;
    var dataType = allTopLevelDataTypesByFeelName.get(typeRef !== null && typeRef !== void 0 ? typeRef : DmnBuiltInDataType.Undefined);
    if (logicType === "literalExpression") {
        var literalExpression = {
            __$$element: "literalExpression",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
        };
        widthsById.set(literalExpression["@_id"], [LITERAL_EXPRESSION_MIN_WIDTH]);
        return literalExpression;
    }
    else if (logicType === "functionDefinition") {
        var functionExpression = {
            __$$element: "functionDefinition",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            "@_kind": "FEEL",
            expression: undefined,
        };
        return functionExpression;
    }
    else if (logicType === "context") {
        var maxWidthBasedOnEntryNames_1 = CONTEXT_ENTRY_VARIABLE_MIN_WIDTH;
        var contextEntries = void 0;
        if (!dataType || !isStruct(dataType.itemDefinition)) {
            contextEntries = [
                {
                    "@_id": generateUuid(),
                    variable: {
                        "@_id": generateUuid(),
                        "@_name": "ContextEntry-1",
                    },
                    expression: undefined,
                },
            ];
        }
        else {
            contextEntries = ((_b = dataType.itemDefinition.itemComponent) !== null && _b !== void 0 ? _b : []).map(function (ic) {
                var _a, _b;
                var name = ic["@_name"];
                var typeRef = isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text;
                maxWidthBasedOnEntryNames_1 = Math.max(maxWidthBasedOnEntryNames_1, (_b = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({ name: name, typeRef: typeRef })) !== null && _b !== void 0 ? _b : CONTEXT_ENTRY_VARIABLE_MIN_WIDTH);
                return {
                    "@_id": generateUuid(),
                    variable: {
                        "@_id": generateUuid(),
                        "@_name": name,
                        "@_typeRef": typeRef,
                    },
                    expression: undefined,
                };
            });
        }
        contextEntries.push({
            "@_id": generateUuid(),
            expression: undefined,
        });
        var contextExpression = {
            __$$element: "context",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            contextEntry: contextEntries,
        };
        widthsById.set(contextExpression["@_id"], [maxWidthBasedOnEntryNames_1]);
        return contextExpression;
    }
    else if (logicType === "list") {
        var listExpression = {
            __$$element: "list",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            expression: [
                undefined,
            ],
        };
        return listExpression;
    }
    else if (logicType === "invocation") {
        var invocationExpression = {
            __$$element: "invocation",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            binding: [
                {
                    parameter: {
                        "@_id": generateUuid(),
                        "@_name": INVOCATION_EXPRESSION_DEFAULT_PARAMETER_NAME,
                        "@_typeRef": undefined,
                    },
                    expression: undefined,
                },
            ],
            expression: {
                __$$element: "literalExpression",
                "@_id": generateUuid(),
                text: { __$$text: "FUNCTION NAME" },
            },
        };
        widthsById.set(invocationExpression["@_id"], [CONTEXT_ENTRY_VARIABLE_MIN_WIDTH]);
        return invocationExpression;
    }
    else if (logicType === "relation") {
        var isSimple = !dataType || !isStruct(dataType.itemDefinition);
        var relationExpression = {
            __$$element: "relation",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            row: [
                {
                    "@_id": generateUuid(),
                    expression: [
                        {
                            __$$element: "literalExpression",
                            "@_id": generateUuid(),
                            text: { __$$text: RELATION_EXPRESSION_DEFAULT_VALUE },
                        },
                    ],
                },
            ],
            column: isSimple
                ? [
                    {
                        "@_id": generateUuid(),
                        "@_name": (_c = dataType === null || dataType === void 0 ? void 0 : dataType.itemDefinition["@_name"]) !== null && _c !== void 0 ? _c : "column-1",
                        "@_typeRef": dataType === null || dataType === void 0 ? void 0 : dataType.feelName,
                    },
                ]
                : ((_d = dataType.itemDefinition.itemComponent) !== null && _d !== void 0 ? _d : []).map(function (ic) {
                    var _a;
                    var name = ic["@_name"];
                    var typeRef = isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text;
                    return {
                        "@_id": generateUuid(),
                        "@_name": name,
                        "@_typeRef": typeRef,
                    };
                }),
        };
        widthsById.set(relationExpression["@_id"], __spreadArray([
            BEE_TABLE_ROW_INDEX_COLUMN_WIDTH
        ], __read(((_e = relationExpression.column) !== null && _e !== void 0 ? _e : []).map(function (c) {
            var _a;
            return (_a = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                name: c["@_name"],
                typeRef: c["@_typeRef"],
            })) !== null && _a !== void 0 ? _a : RELATION_EXPRESSION_COLUMN_DEFAULT_WIDTH;
        })), false));
        return relationExpression;
    }
    else if (logicType === "decisionTable") {
        var singleOutputColumn = {
            name: "Output-1",
            typeRef: dataType === null || dataType === void 0 ? void 0 : dataType.feelName,
        };
        var singleInputColumn = {
            name: "Input-1",
            typeRef: undefined,
        };
        var input = (_g = (_f = getInputs === null || getInputs === void 0 ? void 0 : getInputs()) === null || _f === void 0 ? void 0 : _f.map(function (input) { return ({
            "@_id": generateUuid(),
            inputExpression: {
                "@_id": generateUuid(),
                text: { __$$text: input.name },
                "@_typeRef": input.typeRef,
            },
        }); })) !== null && _g !== void 0 ? _g : [
            {
                "@_id": generateUuid(),
                inputExpression: {
                    "@_id": generateUuid(),
                    text: { __$$text: singleInputColumn.name },
                    "@_typeRef": singleInputColumn.typeRef,
                },
            },
        ];
        var output = !dataType || !isStruct(dataType.itemDefinition)
            ? [
                {
                    "@_id": generateUuid(),
                    "@_name": singleOutputColumn.name,
                    "@_typeRef": singleOutputColumn.typeRef,
                },
            ]
            : ((_h = dataType.itemDefinition.itemComponent) !== null && _h !== void 0 ? _h : []).map(function (ic) {
                var _a;
                return ({
                    "@_id": generateUuid(),
                    "@_name": ic["@_name"],
                    "@_typeRef": isStruct(ic) ? DmnBuiltInDataType.Any : (_a = ic.typeRef) === null || _a === void 0 ? void 0 : _a.__$$text,
                });
            });
        var decisionTableExpression = {
            __$$element: "decisionTable",
            "@_id": generateUuid(),
            "@_typeRef": typeRef,
            "@_hitPolicy": "UNIQUE",
            input: input,
            output: output,
            annotation: [
                {
                    "@_name": "Annotations",
                },
            ],
            rule: [
                {
                    "@_id": generateUuid(),
                    inputEntry: input.map(function () { return ({
                        "@_id": generateUuid(),
                        text: { __$$text: DECISION_TABLE_INPUT_DEFAULT_VALUE },
                    }); }),
                    outputEntry: output.map(function () { return ({
                        "@_id": generateUuid(),
                        text: { __$$text: DECISION_TABLE_OUTPUT_DEFAULT_VALUE },
                    }); }),
                    annotationEntry: [{ text: { __$$text: "// Your annotations here" } }],
                },
            ],
        };
        widthsById.set(decisionTableExpression["@_id"], __spreadArray(__spreadArray(__spreadArray([
            BEE_TABLE_ROW_INDEX_COLUMN_WIDTH
        ], __read(((_j = decisionTableExpression.input) !== null && _j !== void 0 ? _j : []).map(function (input) {
            var _a, _b, _c, _d, _e;
            return (_e = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                name: (_d = (_b = (_a = input["@_label"]) !== null && _a !== void 0 ? _a : input.inputExpression["@_label"]) !== null && _b !== void 0 ? _b : (_c = input.inputExpression.text) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "",
                typeRef: input.inputExpression["@_typeRef"],
            })) !== null && _e !== void 0 ? _e : DECISION_TABLE_INPUT_DEFAULT_WIDTH;
        })), false), __read(((_k = decisionTableExpression.output) !== null && _k !== void 0 ? _k : []).map(function (output) {
            var _a, _b, _c;
            return (_c = getDefaultColumnWidth === null || getDefaultColumnWidth === void 0 ? void 0 : getDefaultColumnWidth({
                name: (_b = (_a = output["@_label"]) !== null && _a !== void 0 ? _a : output["@_name"]) !== null && _b !== void 0 ? _b : "",
                typeRef: output["@_typeRef"],
            })) !== null && _c !== void 0 ? _c : DECISION_TABLE_OUTPUT_DEFAULT_WIDTH;
        })), false), __read(((_l = decisionTableExpression.annotation) !== null && _l !== void 0 ? _l : []).map(function () { return DECISION_TABLE_ANNOTATION_DEFAULT_WIDTH; })), false));
        return decisionTableExpression;
    }
    else if (logicType === "conditional") {
        var conditionalExpression = {
            "@_id": generateUuid(),
            __$$element: "conditional",
            if: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            then: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            else: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return conditionalExpression;
    }
    else if (logicType === "for") {
        var forExpression = {
            "@_id": generateUuid(),
            __$$element: "for",
            return: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return forExpression;
    }
    else if (logicType == "some") {
        var someExpression = {
            "@_id": generateUuid(),
            __$$element: "some",
            satisfies: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return someExpression;
    }
    else if (logicType === "every") {
        var everyExpression = {
            "@_id": generateUuid(),
            __$$element: "every",
            satisfies: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return everyExpression;
    }
    else if (logicType === "filter") {
        var filterExpression = {
            "@_id": generateUuid(),
            __$$element: "filter",
            match: {
                "@_id": generateUuid(),
                expression: undefined,
            },
            in: {
                "@_id": generateUuid(),
                expression: undefined,
            },
        };
        return filterExpression;
    }
    else {
        throw new Error("No default expression available for ".concat(logicType, "."));
    }
}
//# sourceMappingURL=getDefaultBoxedExpression.js.map