import { IMinimatch } from "minimatch";
export declare enum EnvelopeContentType {
    PATH = 0,
    CONTENT = 1
}
export declare type EnvelopeContent = {
    type: EnvelopeContentType.PATH;
    path: string;
} | {
    type: EnvelopeContentType.CONTENT;
    content: string;
};
export declare class EnvelopeMapping {
    private readonly args;
    matcher: IMinimatch;
    constructor(args: {
        type: string;
        filePathGlob: string;
        resourcesPathPrefix: string;
        envelopeContent: EnvelopeContent;
    });
    get type(): string;
    get filePathGlob(): string;
    get resourcesPathPrefix(): string;
    get envelopeContent(): EnvelopeContent;
}
export declare class EditorEnvelopeLocator {
    readonly targetOrigin: string;
    readonly envelopeMappings: EnvelopeMapping[];
    constructor(targetOrigin: string, envelopeMappings: EnvelopeMapping[]);
    getEnvelopeMapping(path: string): EnvelopeMapping | undefined;
    hasMappingFor(path: string): boolean;
}
//# sourceMappingURL=EditorEnvelopeLocator.d.ts.map