import React from "react";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { ProcessInstanceIconCreator } from "../utils/ProcessListUtils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ErrorPopover = ({ processInstanceData, onSkipClick, onRetryClick, ouiaId, ouiaSafe, }) => {
    var _a;
    return (React.createElement(Popover, Object.assign({ zIndex: 300, id: processInstanceData.id, headerContent: React.createElement("div", null, "Process error"), bodyContent: React.createElement("div", null, processInstanceData.error ? processInstanceData.error.message : "No error message found"), footerContent: ((_a = processInstanceData.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
            processInstanceData.serviceUrl && [
            React.createElement(Button, { key: "confirm1", id: "skip-button", "data-testid": "skip-button", variant: "secondary", onClick: () => onSkipClick(processInstanceData), className: "pf-u-mr-sm" }, "Skip"),
            React.createElement(Button, { key: "confirm2", variant: "secondary", id: "retry-button", "data-testid": "retry-button", onClick: () => onRetryClick(processInstanceData), className: "pf-u-mr-sm" }, "Retry"),
        ], position: "auto" }, componentOuiaProps(ouiaId, "error-popover", ouiaSafe)),
        React.createElement(Button, { variant: "link", isInline: true, "data-testid": "error-state" }, ProcessInstanceIconCreator(processInstanceData.state))));
};
export default ErrorPopover;
//# sourceMappingURL=ErrorPopover.js.map