import React, { useImperativeHandle, useState } from "react";
import "@patternfly/patternfly/patternfly.css";
import ProcessForm from "./components/ProcessForm/ProcessForm";
import { ProcessFormEnvelopeViewDriver } from "./ProcessFormEnvelopeViewDriver";
export const ProcessFormEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [processDefinition, setProcessDefinition] = useState();
    useImperativeHandle(forwardedRef, () => ({
        initialize: (processDefinitionData) => {
            setProcessDefinition(processDefinitionData);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    if (!processDefinition) {
        return React.createElement(React.Fragment, null);
    }
    return (React.createElement(ProcessForm, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, processDefinition: processDefinition, driver: new ProcessFormEnvelopeViewDriver(props.channelApi), targetOrigin: props.targetOrigin }));
});
export default ProcessFormEnvelopeView;
//# sourceMappingURL=ProcessFormEnvelopeView.js.map