import React from "react";
import { Modal, ModalVariant, ModalBoxBody } from "@patternfly/react-core/dist/js/components/Modal";
import { TextContent, Text } from "@patternfly/react-core/dist/js/components/Text";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const ProcessDetailsErrorModal = ({ errorString, errorModalOpen, errorModalAction, handleErrorModal, label, title, ouiaId, ouiaSafe, }) => {
    const errorModalContent = () => {
        return (React.createElement(ModalBoxBody, null,
            React.createElement(TextContent, null,
                React.createElement(Text, null, errorString))));
    };
    return (React.createElement(Modal, Object.assign({ variant: ModalVariant.small, "aria-labelledby": label, "aria-label": label, title: "", header: title, isOpen: errorModalOpen, onClose: handleErrorModal, actions: errorModalAction }, componentOuiaProps(ouiaId, "process-details-error-modal", ouiaSafe)), errorModalContent()));
};
export default ProcessDetailsErrorModal;
//# sourceMappingURL=ProcessDetailsErrorModal.js.map