import React, { useMemo } from "react";
import { Card, CardHeader, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Table, TableVariant, TableHeader, TableBody, } from "@patternfly/react-table/dist/js/components/Table";
import Moment from "react-moment";
import JobActionsKebab from "../JobActionsKebab/JobActionsKebab";
import { JobsIconCreator } from "../../../utils/Utils";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const JobsPanel = ({ jobs, driver, ouiaId, ouiaSafe }) => {
    const columns = useMemo(() => {
        return [
            {
                title: "Job id",
            },
            {
                title: "Status",
            },
            {
                title: "Expiration time",
            },
            {
                title: "Actions",
            },
        ];
    }, []);
    const rows = useMemo(() => {
        if (!jobs) {
            return [];
        }
        return jobs.map((job) => {
            return {
                cells: [
                    {
                        title: (React.createElement(Tooltip, { content: job.id },
                            React.createElement("span", null, job.id.substring(0, 7)))),
                    },
                    {
                        title: JobsIconCreator(job.status),
                    },
                    {
                        title: (React.createElement(React.Fragment, null, job.expirationTime ? (React.createElement(React.Fragment, null,
                            " ",
                            "expires in",
                            " ",
                            React.createElement(Moment, { fromNow: true, ago: true }, job.expirationTime))) : ("N/A"))),
                    },
                    {
                        title: React.createElement(JobActionsKebab, { job: job, driver: driver }),
                    },
                ],
            };
        });
    }, [driver, jobs]);
    if (jobs.length > 0) {
        return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "process-details-jobs-panel")),
            React.createElement(CardHeader, null,
                React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Jobs")),
            React.createElement(CardBody, null,
                React.createElement(Table, { "aria-label": "Process details jobs panel", "aria-labelledby": "Process details jobs panel", variant: TableVariant.compact, rows: rows, cells: columns },
                    React.createElement(TableHeader, null),
                    React.createElement(TableBody, null)))));
    }
    else {
        return null;
    }
};
export default JobsPanel;
//# sourceMappingURL=JobsPanel.js.map