import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { ProcessDefinitionListChannelApiImpl } from "./ProcessDefinitionListChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedProcessDefinitionList = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.processDefinitionList__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            singularProcessLabel: props.singularProcessLabel,
        });
    }, []);
    return (React.createElement(EmbeddedProcessDefinitionListEnvelope, { ref: forwardedRef, apiImpl: new ProcessDefinitionListChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedProcessDefinitionListEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedProcessDefinitionList.js.map