var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import _ from "lodash";
import * as React from "react";
import { useCallback } from "react";
import { BeeTableHeaderVisibility } from "../../api";
import { BeeTableTh } from "./BeeTableTh";
import { BeeTableThResizable } from "./BeeTableThResizable";
import { getCanvasFont, getTextWidth } from "../../resizing/WidthsToFitData";
import { BeeTableThController } from "./BeeTableThController";
import { assertUnreachable } from "../../expressions/ExpressionDefinitionRoot/ExpressionDefinitionLogicTypeSelector";
import { InlineEditableTextInput } from "./InlineEditableTextInput";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
export function BeeTableHeader({ reactTableInstance, editColumnLabel, headerVisibility = BeeTableHeaderVisibility.AllLevels, skipLastHeaderGroup, getColumnKey, onColumnUpdates, isEditableHeader, onColumnAdded, onHeaderClick, onHeaderKeyUp, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, resizerStopBehavior, lastColumnMinWidth, setActiveCellEditing, }) {
    const getColumnLabel = useCallback((groupType) => {
        if (_.isObject(editColumnLabel) && _.has(editColumnLabel, groupType)) {
            return editColumnLabel[groupType];
        }
        if (typeof editColumnLabel === "string") {
            return editColumnLabel;
        }
    }, [editColumnLabel]);
    const onExpressionHeaderUpdated = useCallback((column, columnIndex) => {
        return ({ "@_label": name = DEFAULT_EXPRESSION_VARIABLE_NAME, "@_typeRef": typeRef = undefined }) => {
            onColumnUpdates === null || onColumnUpdates === void 0 ? void 0 : onColumnUpdates([
                {
                    columnIndex: columnIndex - 1,
                    typeRef,
                    name,
                    column,
                },
            ]);
        };
    }, [onColumnUpdates]);
    const renderRowIndexColumn = useCallback((column, rowIndex, rowSpan) => {
        var _a, _b;
        const columnKey = getColumnKey(column);
        const classNames = `${columnKey} fixed-column no-clickable-cell counter-header-cell`;
        return (_jsx(BeeTableTh, Object.assign({ rowSpan: rowSpan, column: column, columnKey: columnKey, columnIndex: 0, rowIndex: rowIndex, thProps: column.getHeaderProps(), className: classNames, groupType: column.groupType, isLastLevelColumn: ((_b = (_a = column.columns) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) <= 0, shouldShowColumnsInlineControls: shouldShowRowsInlineControls }, { children: _jsx("div", Object.assign({ className: "header-cell", "data-ouia-component-type": "expression-column-header" }, { children: column.label })) }), columnKey));
    }, [getColumnKey, shouldShowRowsInlineControls]);
    const renderColumn = useCallback((rowIndex, column, columnIndex, visitedColumns, rowSpan) => {
        const thRef = React.createRef();
        const ret = column.isRowIndexColumn ? (_jsx(React.Fragment, { children: shouldRenderRowIndexColumn && renderRowIndexColumn(column, rowIndex, rowSpan) }, "row-index-column")) : (_jsx(React.Fragment, { children: !visitedColumns.has(column) && (_jsx(BeeTableThResizable, { forwardRef: thRef, onHeaderClick: onHeaderClick, onHeaderKeyUp: onHeaderKeyUp, resizerStopBehavior: resizerStopBehavior, rowSpan: rowSpan, shouldRenderRowIndexColumn: shouldRenderRowIndexColumn, isEditableHeader: isEditableHeader, shouldShowColumnsInlineControls: shouldShowRowsInlineControls, getColumnKey: getColumnKey, getColumnLabel: getColumnLabel, reactTableInstance: reactTableInstance, column: column, columnIndex: columnIndex, rowIndex: rowIndex, onColumnAdded: onColumnAdded, onExpressionHeaderUpdated: ({ name, typeRef }) => onExpressionHeaderUpdated(column, columnIndex)({ "@_label": name, "@_typeRef": typeRef }), lastColumnMinWidth: columnIndex === reactTableInstance.allColumns.length - 1 ? lastColumnMinWidth : undefined, onGetWidthToFitData: () => {
                    var _a, _b, _c;
                    if (column.isInlineEditable) {
                        const inlineEditablePreview = thRef.current.querySelector(".inline-editable-preview");
                        return Math.ceil(getTextWidth((_a = inlineEditablePreview.textContent) !== null && _a !== void 0 ? _a : "", getCanvasFont(inlineEditablePreview)));
                    }
                    else {
                        const name = thRef.current.querySelector(".expression-info-name");
                        const typeRef = thRef.current.querySelector(".expression-info-data-type");
                        return Math.ceil(Math.max(getTextWidth((_b = name.textContent) !== null && _b !== void 0 ? _b : "", getCanvasFont(name)), getTextWidth((_c = typeRef.textContent) !== null && _c !== void 0 ? _c : "", getCanvasFont(typeRef))));
                    }
                }, headerCellInfo: _jsxs("div", Object.assign({ className: "expression-info header-cell-info", "data-ouia-component-type": "expression-column-header-cell-info" }, { children: [column.headerCellElement ? (column.headerCellElement) : column.isInlineEditable ? (_jsx(InlineEditableTextInput, { setActiveCellEditing: setActiveCellEditing, columnIndex: columnIndex, rowIndex: rowIndex, value: column.label, onChange: (value) => {
                                onExpressionHeaderUpdated(column, columnIndex)({ "@_label": value, "@_typeRef": column.dataType });
                            } })) : (_jsx("p", Object.assign({ className: "expression-info-name pf-u-text-truncate name" }, { children: column.label }))), column.dataType ? (_jsxs("p", Object.assign({ className: "expression-info-data-type pf-u-text-truncate data-type" }, { children: ["(", column.dataType, ")"] }))) : null] })) })) }, getColumnKey(column)));
        visitedColumns.add(column);
        return ret;
    }, [
        shouldRenderRowIndexColumn,
        renderRowIndexColumn,
        getColumnKey,
        reactTableInstance,
        onHeaderClick,
        onHeaderKeyUp,
        resizerStopBehavior,
        isEditableHeader,
        shouldShowRowsInlineControls,
        getColumnLabel,
        onColumnAdded,
        lastColumnMinWidth,
        setActiveCellEditing,
        onExpressionHeaderUpdated,
    ]);
    const shouldRenderHeaderGroup = useCallback((rowIndex) => {
        if (rowIndex === -1 && skipLastHeaderGroup) {
            return false;
        }
        switch (headerVisibility) {
            case BeeTableHeaderVisibility.None:
                return false;
            case BeeTableHeaderVisibility.AllLevels:
                return true;
            case BeeTableHeaderVisibility.SecondToLastLevel:
                return rowIndex === -2;
            case BeeTableHeaderVisibility.LastLevel:
                return rowIndex === -1;
            default:
                assertUnreachable(headerVisibility);
        }
    }, [headerVisibility, skipLastHeaderGroup]);
    const renderHeaderGroups = useCallback(() => {
        const visitedColumns = new Set();
        return reactTableInstance.headerGroups.map((headerGroup, index) => {
            const rowIndex = -(reactTableInstance.headerGroups.length - index);
            let lastParentalHeaderCellIndex = 0;
            const _a = Object.assign(Object.assign({}, headerGroup.getHeaderGroupProps()), { style: {} }), { key } = _a, props = __rest(_a, ["key"]);
            if (shouldRenderHeaderGroup(rowIndex)) {
                return (_jsx("tr", Object.assign({}, props, { children: headerGroup.headers.map((column) => {
                        const { placeholder, depth } = getDeepestPlaceholder(column);
                        const columnIndex = getColumnIndexOfHeader(reactTableInstance, placeholder) >= 0
                            ? getColumnIndexOfHeader(reactTableInstance, placeholder)
                            : lastParentalHeaderCellIndex++;
                        if (placeholder.isRowIndexColumn) {
                            if (headerVisibility === BeeTableHeaderVisibility.AllLevels) {
                                if (rowIndex === -reactTableInstance.headerGroups.length) {
                                    return renderColumn(rowIndex + depth - 1, placeholder, columnIndex, visitedColumns, reactTableInstance.headerGroups.length);
                                }
                            }
                            else {
                                return renderColumn(rowIndex + depth - 1, placeholder, columnIndex, visitedColumns, depth);
                            }
                        }
                        else {
                            return renderColumn(rowIndex + depth - 1, placeholder, columnIndex, visitedColumns, depth);
                        }
                    }) }), key));
            }
            else {
                return (_jsx(React.Fragment, { children: headerGroup.headers.map((column) => {
                        const { placeholder } = getDeepestPlaceholder(column);
                        const columnIndex = getColumnIndexOfHeader(reactTableInstance, placeholder) >= 0
                            ? getColumnIndexOfHeader(reactTableInstance, placeholder)
                            : lastParentalHeaderCellIndex++;
                        return (_jsx(BeeTableThController, { columnIndex: columnIndex, column: column, reactTableInstance: reactTableInstance, shouldRenderRowIndexColumn: shouldRenderRowIndexColumn }, getColumnKey(column)));
                    }) }, key));
            }
        });
    }, [
        getColumnKey,
        headerVisibility,
        reactTableInstance,
        renderColumn,
        shouldRenderHeaderGroup,
        shouldRenderRowIndexColumn,
    ]);
    return _jsx(_Fragment, { children: _jsx("thead", { children: renderHeaderGroups() }) });
}
function getDeepestPlaceholder(column) {
    let currentDepth = 1;
    while (column.placeholderOf) {
        column = column.placeholderOf;
        currentDepth++;
    }
    return {
        placeholder: column,
        depth: currentDepth,
    };
}
function getColumnIndexOfHeader(reactTableInstance, column) {
    return reactTableInstance.allColumns.indexOf(column);
}
//# sourceMappingURL=BeeTableHeader.js.map