import * as React from "react";
import { ResizingWidth } from "../resizing/ResizingWidthsContext";
export declare const SELECTION_MIN_ACTIVE_DEPTH = -1;
export declare const SELECTION_MIN_MAX_DEPTH = 0;
export declare const INITIAL_CURRENT_DEPTH: {
    active: undefined;
    max: number;
};
export interface BeeTableCellCoordinates {
    columnIndex: number;
    rowIndex: number;
}
export interface BeeTableSelectionActiveCell {
    columnIndex: number;
    rowIndex: number;
    isEditing: boolean;
}
export declare enum SelectionPart {
    ActiveCell = 0,
    SelectionEnd = 1,
    SelectionStart = 2
}
export interface BeeTableSelectionContextType {
    activeCell: BeeTableSelectionActiveCell | undefined;
    activeCellForNestedTables: BeeTableSelectionActiveCell | undefined;
    selectionEnd: BeeTableSelectionActiveCell | undefined;
    selectionStart: BeeTableSelectionActiveCell | undefined;
    currentDepth: {
        active: number | undefined;
        max: number;
    };
    depth: number;
    isSelectionHere: boolean;
}
export interface BeeTableCoordinatesDispatchContextType {
    setMaxDepth: React.Dispatch<React.SetStateAction<number>>;
}
export interface BeeTableSelectionDispatchContextType {
    setCurrentDepth: React.Dispatch<React.SetStateAction<{
        active: number | undefined;
        max: number;
    }>>;
    erase(): void;
    copy(): void;
    cut(): void;
    paste(): void;
    adaptSelection(args: {
        atRowIndex: number;
        rowCountDelta: number;
        atColumnIndex: number;
        columnCountDelta: number;
    }): void;
    mutateSelection: (args: {
        part: SelectionPart;
        columnCount: (rowIndex: number) => number;
        rowCount: number;
        deltaColumns: number;
        deltaRows: number;
        isEditingActiveCell: boolean;
        keepInsideSelection: boolean;
    }) => void;
    resetSelectionAt: React.Dispatch<React.SetStateAction<(BeeTableSelectionActiveCell & {
        keepSelection?: boolean;
    }) | undefined>>;
    setSelectionEnd: React.Dispatch<React.SetStateAction<BeeTableSelectionActiveCell | undefined>>;
    registerSelectableCellRef(rowIndex: number, columnIndex: number, ref: BeeTableCellRef): BeeTableCellRef;
    deregisterSelectableCellRef(rowIndex: number, columnIndex: number, ref: BeeTableCellRef): void;
}
export interface BeeTableCoordinatesContextType {
    containerCellCoordinates: BeeTableCellCoordinates | undefined;
}
export declare const BeeTableSelectionContext: React.Context<BeeTableSelectionContextType>;
export declare const BeeTableCoordinatesContext: React.Context<BeeTableCoordinatesContextType>;
export declare const BeeTableCoordinatesDispatchContext: React.Context<BeeTableCoordinatesDispatchContextType>;
export declare const BeeTableSelectionDispatchContext: React.Context<BeeTableSelectionDispatchContextType>;
export declare type BeeTableCellStatus = {
    isActive: boolean;
    isEditing: boolean;
    isSelected: boolean;
    selectedPositions?: BeeTableSelectionPosition[];
};
export interface BeeTableCellRef {
    setStatus?(args: BeeTableCellStatus): void;
    setValue?(value: string): void;
    getValue?(): string;
    setResizingWidth?: React.Dispatch<React.SetStateAction<ResizingWidth>>;
}
export interface BeeTableSelection {
    active: BeeTableSelectionActiveCell | undefined;
    selectionEnd: BeeTableSelectionActiveCell | undefined;
    selectionStart: BeeTableSelectionActiveCell | undefined;
}
export declare enum BeeTableSelectionPosition {
    Top = "top",
    Bottom = "bottom",
    Left = "left",
    Right = "right"
}
export declare function BeeTableCoordinatesContextProvider({ children, coordinates, }: React.PropsWithChildren<{
    coordinates: BeeTableCellCoordinates;
}>): JSX.Element;
export declare function BeeTableSelectionContextProvider({ children }: React.PropsWithChildren<{}>): JSX.Element;
export declare function useBeeTableSelection(): BeeTableSelectionContextType;
export declare function useBeeTableSelectionDispatch(): BeeTableSelectionDispatchContextType;
export declare function useBeeTableCoordinates(): BeeTableCoordinatesContextType;
export declare function useBeeTableCoordinatesDispatch(): BeeTableCoordinatesDispatchContextType;
export declare function useBeeTableSelectableCellRef(rowIndex: number, columnIndex: number, setValue?: BeeTableCellRef["setValue"], getValue?: BeeTableCellRef["getValue"]): BeeTableCellStatus;
export declare function useBeeTableSelectableCell(cellRef: React.RefObject<HTMLTableCellElement>, rowIndex: number, columnIndex: number, setValue?: BeeTableCellRef["setValue"], getValue?: BeeTableCellRef["getValue"]): {
    cssClasses: string;
    onMouseDown: (e: React.MouseEvent) => void;
    onDoubleClick: (e: React.MouseEvent) => void;
    isActive: boolean;
};
//# sourceMappingURL=BeeTableSelectionContext.d.ts.map