import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { EmptyState, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { CubesIcon } from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { OutlinedTrashAltIcon } from "@patternfly/react-icons/dist/js/icons/outlined-trash-alt-icon";
import { useCallback } from "react";
import { generateUuid, getNextAvailablePrefixedName } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { DataTypeSelector } from "../../expressionVariable/DataTypeSelector";
import "./ParametersPopover.css";
export const ParametersPopover = ({ parameters }) => {
    const { i18n } = useBoxedExpressionEditorI18n();
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const addParameter = useCallback((e) => {
        e.stopPropagation();
        setExpression((prev) => {
            var _a, _b;
            const newParameters = [
                ...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : []),
                {
                    "@_id": generateUuid(),
                    "@_name": getNextAvailablePrefixedName(((_b = prev.formalParameter) !== null && _b !== void 0 ? _b : []).map((p) => p["@_name"]), "p"),
                    "@_typeRef": undefined,
                },
            ];
            const ret = Object.assign(Object.assign({}, prev), { formalParameter: newParameters });
            return ret;
        });
    }, [setExpression]);
    return (_jsx("div", Object.assign({ className: "parameters-editor", onMouseDown: (e) => e.stopPropagation() }, { children: parameters.length ? (_jsxs(_Fragment, { children: [_jsx(Button, Object.assign({ variant: "tertiary", onClickCapture: addParameter, className: "add-parameter" }, { children: i18n.addParameter })), _jsx("div", Object.assign({ className: "parameters-container" }, { children: parameters.map((parameter, index) => (_jsx(ParameterEntry, { parameter: parameter, index: index }, index))) }))] })) : (_jsx("div", Object.assign({ className: "parameters-container-empty" }, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, Object.assign({ headingLevel: "h4" }, { children: i18n.noParametersDefined })), _jsx(Button, Object.assign({ variant: "primary", onClickCapture: addParameter }, { children: i18n.addParameter }))] }) }))) })));
};
function ParameterEntry({ parameter, index }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onNameChange = useCallback((e) => {
        e.stopPropagation();
        setExpression((prev) => {
            var _a;
            const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
            newParameters[index] = Object.assign(Object.assign({}, newParameters[index]), { "@_name": e.target.value });
            const ret = Object.assign(Object.assign({}, prev), { formalParameter: newParameters });
            return ret;
        });
    }, [index, setExpression]);
    const onDataTypeChange = useCallback((typeRef) => {
        setExpression((prev) => {
            var _a;
            const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
            newParameters[index] = Object.assign(Object.assign({}, newParameters[index]), { "@_typeRef": typeRef });
            const ret = Object.assign(Object.assign({}, prev), { formalParameter: newParameters });
            return ret;
        });
    }, [index, setExpression]);
    const onParameterRemove = useCallback((e) => {
        e.stopPropagation();
        setExpression((prev) => {
            var _a;
            const newParameters = [...((_a = prev.formalParameter) !== null && _a !== void 0 ? _a : [])];
            newParameters.splice(index, 1);
            const ret = Object.assign(Object.assign({}, prev), { formalParameter: newParameters });
            return ret;
        });
    }, [index, setExpression]);
    return (_jsxs("div", Object.assign({ className: "parameter-entry" }, { children: [_jsx("input", { className: "parameter-name", type: "text", onBlur: onNameChange, placeholder: "Parameter Name", defaultValue: parameter["@_name"] }), _jsx(DataTypeSelector, { value: parameter["@_typeRef"], onChange: onDataTypeChange, menuAppendTo: "parent" }), _jsx(Button, { variant: "danger", className: "delete-parameter", icon: _jsx(OutlinedTrashAltIcon, {}), iconPosition: "left", onClickCapture: onParameterRemove })] }), `${parameter["@_name"]}_${index}`));
}
//# sourceMappingURL=ParametersPopover.js.map