import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent } from "@patternfly/react-core/dist/js/components/Text";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import React from "react";
import ReactJson from "react-json-view";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { WorkflowInstanceState } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import "../styles.css";
const WorkflowVariables = ({ displayLabel, displaySuccess, ouiaId, ouiaSafe, setDisplayLabel, setUpdateJson, updateJson, workflowInstance, }) => {
    const handleVariablesChange = (e) => {
        setUpdateJson(Object.assign(Object.assign({}, updateJson), e.updated_src));
        setDisplayLabel(true);
    };
    const checkWorkflowStatus = workflowInstance.state === WorkflowInstanceState.Completed ||
        workflowInstance.state === WorkflowInstanceState.Aborted
        ? false
        : handleVariablesChange;
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "workflow-variables", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Variables"),
            displayLabel && (React.createElement(Label, { color: "orange", icon: React.createElement(InfoCircleIcon, null) },
                " ",
                "Changes are not saved yet")),
            React.createElement(Label, { color: "green", icon: React.createElement(InfoCircleIcon, null), className: displaySuccess
                    ? "kogito-workflow-details--variables__label-fadeIn"
                    : "kogito-workflow-details--variables__label-fadeOut" },
                " ",
                "Changes are saved")),
        React.createElement(CardBody, null,
            React.createElement(TextContent, null,
                React.createElement("div", null,
                    React.createElement(ReactJson, { src: updateJson, name: false, onEdit: checkWorkflowStatus, onAdd: checkWorkflowStatus, onDelete: checkWorkflowStatus }))))));
};
export default React.memo(WorkflowVariables);
//# sourceMappingURL=WorkflowVariables.js.map