export default class WorkflowDetailsEnvelopeViewDriver {
    constructor(channelApi) {
        this.channelApi = channelApi;
    }
    handleWorkflowAbort(workflowInstance) {
        return this.channelApi.requests.workflowDetails__handleWorkflowAbort(workflowInstance);
    }
    cancelJob(job) {
        return this.channelApi.requests.workflowDetails__cancelJob(job);
    }
    rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate) {
        return this.channelApi.requests.workflowDetails__rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
    }
    getTriggerableNodes(workflowInstance) {
        return this.channelApi.requests.workflowDetails__getTriggerableNodes(workflowInstance);
    }
    handleNodeTrigger(workflowInstance, node) {
        return this.channelApi.requests.workflowDetails__handleNodeTrigger(workflowInstance, node);
    }
    handleWorkflowVariableUpdate(workflowInstance, updatedJson) {
        return this.channelApi.requests.workflowDetails__handleWorkflowVariableUpdate(workflowInstance, updatedJson);
    }
    workflowDetailsQuery(id) {
        return this.channelApi.requests.workflowDetails__workflowDetailsQuery(id);
    }
    jobsQuery(id) {
        return this.channelApi.requests.workflowDetails__jobsQuery(id);
    }
    openWorkflowInstanceDetails(id) {
        return this.channelApi.notifications.workflowDetails__openWorkflowDetails.send(id);
    }
    handleWorkflowRetry(workflowInstance) {
        return this.channelApi.requests.workflowDetails__handleWorkflowRetry(workflowInstance);
    }
    handleNodeInstanceCancel(workflowInstance, node) {
        return this.channelApi.requests.workflowDetails__handleNodeInstanceCancel(workflowInstance, node);
    }
    handleWorkflowSkip(workflowInstance) {
        return this.channelApi.requests.workflowDetails__handleWorkflowSkip(workflowInstance);
    }
    handleNodeInstanceRetrigger(workflowInstance, node) {
        return this.channelApi.requests.workflowDetails__handleNodeInstanceRetrigger(workflowInstance, node);
    }
}
//# sourceMappingURL=WorkflowDetailsEnvelopeViewDriver.js.map