import * as React from "react";
import { useEffect, useImperativeHandle, useMemo, useRef } from "react";
import { RequestDataEditorController, } from "./RequestDataEditorController";
import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import "../styles.css";
const RefForwardingRequestDataEditor = ({ content, onContentChange, isReadOnly }, forwardedRef) => {
    const container = useRef(null);
    const controller = useMemo(() => {
        return new RequestDataEditorController(content, onContentChange, isReadOnly);
    }, [content, onContentChange, isReadOnly]);
    useEffect(() => {
        if (container.current) {
            controller.show(container.current, EditorTheme.LIGHT);
        }
        return () => {
            controller.dispose();
        };
    }, [content, controller]);
    useImperativeHandle(forwardedRef, () => controller, [controller]);
    return React.createElement("div", { className: "kogito-request-data-editor-container", ref: container });
};
export const RequestDataEditor = React.forwardRef(RefForwardingRequestDataEditor);
//# sourceMappingURL=RequestDataEditor.js.map