import React from "react";
import { OUIAProps } from "../../ouiaTools";
export declare enum BulkListType {
    PROCESS_INSTANCE = "process_instance",
    JOB = "job",
    WORKFLOW = "workflow"
}
export interface IOperationResult {
    successItems: BulkListItem[];
    failedItems: BulkListItem[];
    ignoredItems: BulkListItem[];
}
export interface IOperationMessages {
    successMessage: string;
    warningMessage?: string;
    ignoredMessage: string;
    noItemsMessage: string;
}
export interface IOperationFunctions {
    perform: () => void;
}
export interface IOperationResults {
    [key: string]: IOperationResult;
}
export interface IOperation {
    type: string;
    results: IOperationResult;
    messages: IOperationMessages;
    functions: IOperationFunctions;
}
export interface IOperations {
    [key: string]: IOperation;
}
export interface IOwnProps {
    operationResult: IOperation;
}
export interface BulkListItem {
    id: string;
    name?: string;
    description?: string;
    errorMessage?: string;
}
export declare const BulkList: React.FC<IOwnProps & OUIAProps>;
//# sourceMappingURL=BulkList.d.ts.map